/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.simple;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketClientHandler;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinResponseDecoder;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.ser.GraphBinaryMessageSerializerV1;
import org.apache.tinkerpop.gremlin.driver.simple.AbstractClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketClient.class);
    private final Channel channel;

    public WebSocketClient() {
        this(URI.create("ws://localhost:8182/gremlin"));
    }

    public WebSocketClient(URI uri) {
        super("ws-client-%d");
        Bootstrap b = (Bootstrap)new Bootstrap().group(this.group);
        b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        String protocol = uri.getScheme();
        if (!"ws".equalsIgnoreCase(protocol) && !"wss".equalsIgnoreCase(protocol)) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        final String host = uri.getHost();
        final int port = uri.getPort() == -1 ? ("ws".equalsIgnoreCase(protocol) ? 80 : ("wss".equalsIgnoreCase(protocol) ? 443 : -1)) : uri.getPort();
        try {
            boolean ssl = "wss".equalsIgnoreCase(protocol);
            final SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
            final WebSocketClientHandler wsHandler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)EmptyHttpHeaders.INSTANCE, (int)65536), 10000L, false);
            final GraphBinaryMessageSerializerV1 serializer = new GraphBinaryMessageSerializerV1();
            ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (sslCtx != null) {
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                    }
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(65536), wsHandler, new WebSocketGremlinRequestEncoder(true, serializer), new WebSocketGremlinResponseDecoder(serializer), WebSocketClient.this.callbackResponseHandler});
                }
            });
            this.channel = b.connect(uri.getHost(), uri.getPort()).sync().channel();
            wsHandler.handshakeFuture().get(30L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void writeAndFlush(RequestMessage requestMessage) throws Exception {
        this.channel.writeAndFlush((Object)requestMessage);
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close().get(30L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            logger.error("Failure closing simple WebSocketClient", (Throwable)ex);
        }
        finally {
            if (!this.group.shutdownGracefully().awaitUninterruptibly(30L, TimeUnit.SECONDS)) {
                logger.error("Could not cleanly shutdown thread pool on WebSocketClient");
            }
        }
    }
}

