/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.message;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public enum ResponseStatusCode {
    SUCCESS(200),
    NO_CONTENT(204),
    PARTIAL_CONTENT(206),
    UNAUTHORIZED(401),
    FORBIDDEN(403),
    AUTHENTICATE(407),
    TOO_MANY_REQUESTS(429),
    REQUEST_ERROR_SERIALIZATION(497),
    REQUEST_ERROR_MALFORMED_REQUEST(498),
    REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS(499),
    SERVER_ERROR(500),
    SERVER_ERROR_TEMPORARY(596),
    SERVER_ERROR_EVALUATION(597),
    SERVER_ERROR_TIMEOUT(598),
    SERVER_ERROR_SERIALIZATION(599);

    private final int value;
    private static final Map<Integer, ResponseStatusCode> codeValueMap;

    public static ResponseStatusCode getFromValue(int codeValue) {
        return codeValueMap.get(codeValue);
    }

    private ResponseStatusCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSuccess() {
        return String.valueOf(this.value).startsWith("2");
    }

    public boolean isFinalResponse() {
        return this != PARTIAL_CONTENT && this != AUTHENTICATE;
    }

    static {
        codeValueMap = new HashMap<Integer, ResponseStatusCode>();
        Stream.of(ResponseStatusCode.values()).forEach(code -> codeValueMap.put(code.getValue(), (ResponseStatusCode)((Object)code)));
    }
}

