/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class ClassSerializer
extends SimpleTypeSerializer<Class> {
    public ClassSerializer() {
        super(DataType.CLASS);
    }

    @Override
    protected Class readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        String name = context.readValue(buffer, String.class, false);
        try {
            return Class.forName(name);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void writeValue(Class value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        context.writeValue(value.getName(), buffer, false);
    }
}

