/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class ZonedDateTimeSerializer
extends SimpleTypeSerializer<ZonedDateTime> {
    public ZonedDateTimeSerializer() {
        super(DataType.ZONEDATETIME);
    }

    @Override
    ZonedDateTime readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        LocalDateTime ldt = context.readValue(buffer, LocalDateTime.class, false);
        ZoneOffset zo = context.readValue(buffer, ZoneOffset.class, false);
        return ZonedDateTime.of(ldt, zo);
    }

    @Override
    public ByteBuf writeValue(ZonedDateTime value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(2);
        result.addComponent(true, context.writeValue(value.toLocalDateTime(), allocator, false));
        result.addComponent(true, context.writeValue(value.getOffset(), allocator, false));
        return result;
    }
}

