/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.ZoneOffset;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class ZoneOffsetSerializer
extends SimpleTypeSerializer<ZoneOffset> {
    public ZoneOffsetSerializer() {
        super(DataType.ZONEOFFSET);
    }

    @Override
    ZoneOffset readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return ZoneOffset.ofTotalSeconds(buffer.readInt());
    }

    @Override
    public ByteBuf writeValue(ZoneOffset value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return allocator.buffer(4).writeInt(value.getTotalSeconds());
    }
}

