/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.YearMonth;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class YearMonthSerializer
extends SimpleTypeSerializer<YearMonth> {
    public YearMonthSerializer() {
        super(DataType.YEARMONTH);
    }

    @Override
    YearMonth readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return YearMonth.of(buffer.readInt(), buffer.readByte());
    }

    @Override
    public ByteBuf writeValue(YearMonth value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return allocator.buffer(2).writeInt(value.getYear()).writeByte(value.getMonthValue());
    }
}

