/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class UUIDSerializer
extends SimpleTypeSerializer<UUID> {
    public UUIDSerializer() {
        super(DataType.UUID);
    }

    @Override
    public UUID readValue(ByteBuf buffer, GraphBinaryReader context) {
        return new UUID(buffer.readLong(), buffer.readLong());
    }

    @Override
    public ByteBuf writeValue(UUID value, ByteBufAllocator allocator, GraphBinaryWriter context) {
        return allocator.buffer(16).writeLong(value.getMostSignificantBits()).writeLong(value.getLeastSignificantBits());
    }
}

