/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.LocalDate;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class LocalDateSerializer
extends SimpleTypeSerializer<LocalDate> {
    public LocalDateSerializer() {
        super(DataType.LOCALDATE);
    }

    @Override
    LocalDate readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return LocalDate.of(buffer.readInt(), buffer.readByte(), (int)buffer.readByte());
    }

    @Override
    public ByteBuf writeValue(LocalDate value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return allocator.buffer(6).writeInt(value.getYear()).writeByte(value.getMonthValue()).writeByte(value.getDayOfMonth());
    }
}

