/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class InetAddressSerializer<T extends InetAddress>
extends SimpleTypeSerializer<T> {
    public InetAddressSerializer() {
        super(DataType.INETADDRESS);
    }

    @Override
    T readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int length = buffer.readInt();
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        try {
            return (T)InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException uhe) {
            throw new SerializationException(uhe);
        }
    }

    @Override
    public ByteBuf writeValue(T value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        byte[] bytes = ((InetAddress)value).getAddress();
        return allocator.buffer(4 + bytes.length).writeInt(bytes.length).writeBytes(bytes);
    }
}

