/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceEdge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;

public class EdgeSerializer
extends SimpleTypeSerializer<Edge> {
    public EdgeSerializer() {
        super(DataType.EDGE);
    }

    @Override
    public Edge readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        Object id = context.read(buffer);
        String label = context.readValue(buffer, String.class, false);
        ReferenceVertex inV = new ReferenceVertex(context.read(buffer), context.readValue(buffer, String.class, false));
        ReferenceVertex outV = new ReferenceVertex(context.read(buffer), context.readValue(buffer, String.class, false));
        context.read(buffer);
        context.read(buffer);
        return new ReferenceEdge(id, label, inV, outV);
    }

    @Override
    public ByteBuf writeValue(Edge value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(8);
        result.addComponent(true, context.write(value.id(), allocator));
        result.addComponent(true, context.writeValue(value.label(), allocator, false));
        result.addComponent(true, context.write(value.inVertex().id(), allocator));
        result.addComponent(true, context.writeValue(value.inVertex().label(), allocator, false));
        result.addComponent(true, context.write(value.outVertex().id(), allocator));
        result.addComponent(true, context.writeValue(value.outVertex().label(), allocator, false));
        result.addComponent(true, context.write(null, allocator));
        result.addComponent(true, context.write(null, allocator));
        return result;
    }
}

