/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.Duration;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class DurationSerializer
extends SimpleTypeSerializer<Duration> {
    public DurationSerializer() {
        super(DataType.DURATION);
    }

    @Override
    Duration readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return Duration.ofSeconds(buffer.readLong(), buffer.readInt());
    }

    @Override
    public ByteBuf writeValue(Duration value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return allocator.buffer(12).writeLong(value.getSeconds()).writeInt(value.getNano());
    }
}

