/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class ClassSerializer
extends SimpleTypeSerializer<Class> {
    public ClassSerializer() {
        super(DataType.CLASS);
    }

    @Override
    Class readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        String name = context.readValue(buffer, String.class, false);
        try {
            return Class.forName(name);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ByteBuf writeValue(Class value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return context.writeValue(value.getName(), allocator, false);
    }
}

