/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.util.List;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;

public class ByteCodeSerializer
extends SimpleTypeSerializer<Bytecode> {
    public ByteCodeSerializer() {
        super(DataType.BYTECODE);
    }

    @Override
    public Bytecode readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        Bytecode result = new Bytecode();
        int stepsLength = buffer.readInt();
        for (int i = 0; i < stepsLength; ++i) {
            result.addStep(context.readValue(buffer, String.class, false), ByteCodeSerializer.getInstructionArguments(buffer, context));
        }
        int sourcesLength = buffer.readInt();
        for (int i = 0; i < sourcesLength; ++i) {
            result.addSource(context.readValue(buffer, String.class, false), ByteCodeSerializer.getInstructionArguments(buffer, context));
        }
        return result;
    }

    private static Object[] getInstructionArguments(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int valuesLength = buffer.readInt();
        Object[] values = new Object[valuesLength];
        for (int j = 0; j < valuesLength; ++j) {
            values[j] = context.read(buffer);
        }
        return values;
    }

    @Override
    public ByteBuf writeValue(Bytecode value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        List steps = value.getStepInstructions();
        List sources = value.getSourceInstructions();
        CompositeByteBuf result = allocator.compositeBuffer(2 + steps.size() * 2 + sources.size() * 2);
        this.writeInstructions(allocator, context, steps, result);
        this.writeInstructions(allocator, context, sources, result);
        return result;
    }

    private void writeInstructions(ByteBufAllocator allocator, GraphBinaryWriter context, List<Bytecode.Instruction> instructions, CompositeByteBuf result) throws SerializationException {
        result.addComponent(true, context.writeValue(instructions.size(), allocator, false));
        for (Bytecode.Instruction instruction : instructions) {
            result.addComponents(true, new ByteBuf[]{context.writeValue(instruction.getOperator(), allocator, false), ByteCodeSerializer.getArgumentsBuffer(instruction.getArguments(), allocator, context)});
        }
    }

    private static ByteBuf getArgumentsBuffer(Object[] arguments, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(1 + arguments.length);
        result.addComponent(true, context.writeValue(arguments.length, allocator, false));
        for (Object value : arguments) {
            result.addComponent(true, context.write(value, allocator));
        }
        return result;
    }
}

