/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.driver.AuthProperties;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultQueue;
import org.apache.tinkerpop.gremlin.driver.exception.ResponseException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Handler {
    Handler() {
    }

    static class GremlinResponseHandler
    extends SimpleChannelInboundHandler<ResponseMessage> {
        private static final Logger logger = LoggerFactory.getLogger(GremlinResponseHandler.class);
        private final ConcurrentMap<UUID, ResultQueue> pending;

        public GremlinResponseHandler(ConcurrentMap<UUID, ResultQueue> pending) {
            this.pending = pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void channelRead0(ChannelHandlerContext channelHandlerContext, ResponseMessage response) throws Exception {
            try {
                ResponseStatusCode statusCode = response.getStatus().getCode();
                ResultQueue queue = (ResultQueue)this.pending.get(response.getRequestId());
                if (statusCode == ResponseStatusCode.SUCCESS || statusCode == ResponseStatusCode.PARTIAL_CONTENT) {
                    Object data = response.getResult().getData();
                    Map<String, Object> meta = response.getResult().getMeta();
                    if (!meta.containsKey("sideEffectKey")) {
                        if (data instanceof List) {
                            List listToUnroll = (List)data;
                            listToUnroll.forEach(item -> queue.add(new Result(item)));
                        } else {
                            queue.add(new Result(response.getResult().getData()));
                        }
                    } else {
                        String aggregateTo = meta.getOrDefault("aggregateTo", "none").toString();
                        if (data instanceof List) {
                            List listOfSideEffects = (List)data;
                            listOfSideEffects.forEach(sideEffect -> queue.addSideEffect(aggregateTo, sideEffect));
                        } else {
                            queue.addSideEffect(aggregateTo, data);
                        }
                    }
                } else if (statusCode != ResponseStatusCode.NO_CONTENT) {
                    queue.markError(new ResponseException(response.getStatus().getCode(), response.getStatus().getMessage()));
                }
                if (response.getStatus().getCode() != ResponseStatusCode.PARTIAL_CONTENT) {
                    ((ResultQueue)this.pending.remove(response.getRequestId())).markComplete();
                }
            }
            finally {
                ReferenceCountUtil.release((Object)response);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.error("Could not process the response", cause);
            this.pending.values().forEach(val -> val.markError(cause));
            this.pending.clear();
            if (!IteratorUtils.anyMatch(ExceptionUtils.getThrowableList((Throwable)cause).iterator(), t -> t instanceof SerializationException)) {
                ctx.close();
            }
        }
    }

    static class GremlinSaslAuthenticationHandler
    extends SimpleChannelInboundHandler<ResponseMessage>
    implements CallbackHandler {
        private static final Logger logger = LoggerFactory.getLogger(GremlinSaslAuthenticationHandler.class);
        private static final AttributeKey<Subject> subjectKey = AttributeKey.valueOf((String)"subject");
        private static final AttributeKey<SaslClient> saslClientKey = AttributeKey.valueOf((String)"saslclient");
        private static final Map<String, String> SASL_PROPERTIES = new HashMap<String, String>(){
            {
                this.put("javax.security.sasl.server.authentication", "true");
            }
        };
        private static final byte[] NULL_CHALLENGE = new byte[0];
        private final AuthProperties authProps;

        public GremlinSaslAuthenticationHandler(AuthProperties authProps) {
            this.authProps = authProps;
        }

        protected void channelRead0(ChannelHandlerContext channelHandlerContext, ResponseMessage response) throws Exception {
            if (response.getStatus().getCode() == ResponseStatusCode.AUTHENTICATE) {
                Attribute saslClient = channelHandlerContext.attr(saslClientKey);
                Attribute subject = channelHandlerContext.attr(subjectKey);
                RequestMessage.Builder messageBuilder = RequestMessage.build("authentication");
                if (saslClient.get() == null) {
                    subject.set((Object)this.login());
                    try {
                        saslClient.set((Object)this.saslClient(this.getHostName(channelHandlerContext)));
                    }
                    catch (SaslException saslException) {
                        ResponseMessage clientSideError = ResponseMessage.build(response.getRequestId()).code(ResponseStatusCode.FORBIDDEN).statusMessage(saslException.getMessage()).create();
                        channelHandlerContext.fireChannelRead((Object)clientSideError);
                        return;
                    }
                    messageBuilder.addArg("saslMechanism", this.getMechanism());
                    messageBuilder.addArg("sasl", ((SaslClient)saslClient.get()).hasInitialResponse() ? this.evaluateChallenge((Attribute<Subject>)subject, (Attribute<SaslClient>)saslClient, NULL_CHALLENGE) : null);
                } else {
                    messageBuilder.addArg("sasl", this.evaluateChallenge((Attribute<Subject>)subject, (Attribute<SaslClient>)saslClient, (byte[])response.getResult().getData()));
                }
                channelHandlerContext.writeAndFlush((Object)messageBuilder.create());
            } else {
                channelHandlerContext.fireChannelRead((Object)response);
            }
        }

        @Override
        public void handle(Callback[] callbacks) {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    if (this.authProps.get(AuthProperties.Property.USERNAME) == null) continue;
                    ((NameCallback)callback).setName(this.authProps.get(AuthProperties.Property.USERNAME));
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    if (this.authProps.get(AuthProperties.Property.PASSWORD) == null) continue;
                    ((PasswordCallback)callback).setPassword(this.authProps.get(AuthProperties.Property.PASSWORD).toCharArray());
                    continue;
                }
                logger.warn("SASL handler got a callback of type " + callback.getClass().getCanonicalName());
            }
        }

        private byte[] evaluateChallenge(Attribute<Subject> subject, Attribute<SaslClient> saslClient, byte[] challenge) throws SaslException {
            if (subject.get() == null) {
                return ((SaslClient)saslClient.get()).evaluateChallenge(challenge);
            }
            try {
                return Subject.doAs((Subject)subject.get(), () -> ((SaslClient)saslClient.get()).evaluateChallenge(challenge));
            }
            catch (PrivilegedActionException e) {
                throw (SaslException)e.getException();
            }
        }

        private Subject login() throws LoginException {
            if (this.authProps.get(AuthProperties.Property.JAAS_ENTRY) != null) {
                LoginContext login = new LoginContext(this.authProps.get(AuthProperties.Property.JAAS_ENTRY));
                login.login();
                return login.getSubject();
            }
            return null;
        }

        private SaslClient saslClient(String hostname) throws SaslException {
            return Sasl.createSaslClient(new String[]{this.getMechanism()}, null, this.authProps.get(AuthProperties.Property.PROTOCOL), hostname, SASL_PROPERTIES, this);
        }

        private String getHostName(ChannelHandlerContext channelHandlerContext) {
            return ((InetSocketAddress)channelHandlerContext.channel().remoteAddress()).getAddress().getCanonicalHostName();
        }

        private String getMechanism() {
            if (this.authProps.get(AuthProperties.Property.USERNAME) != null && this.authProps.get(AuthProperties.Property.PASSWORD) != null) {
                return "PLAIN";
            }
            return "GSSAPI";
        }
    }
}

