/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.remote;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.process.remote.traversal.AbstractRemoteTraversalSideEffects;

public class DriverRemoteTraversalSideEffects
extends AbstractRemoteTraversalSideEffects {
    private final Client client;
    private Set<String> keys = null;
    private final UUID serverSideEffect;
    private final Host host;
    private final Map<String, Object> sideEffects = new HashMap<String, Object>();

    public DriverRemoteTraversalSideEffects(Client client, UUID serverSideEffect, Host host) {
        this.client = client;
        this.serverSideEffect = serverSideEffect;
        this.host = host;
    }

    public <V> V get(String key) throws IllegalArgumentException {
        if (!this.sideEffects.containsKey(key)) {
            RequestMessage msg = RequestMessage.build("gather").addArg("sideEffect", this.serverSideEffect).addArg("sideEffectKey", key).addArg("host", this.host).processor("traversal").create();
            try {
                Result result = this.client.submitAsync(msg).get().one();
                this.sideEffects.put(key, null == result ? null : result.getObject());
            }
            catch (Exception ex) {
                Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
                if (root.getMessage().equals("Could not find side-effects for " + this.serverSideEffect + ".")) {
                    this.sideEffects.put(key, null);
                }
                throw new RuntimeException("Could not get keys", root);
            }
        }
        return (V)this.sideEffects.get(key);
    }

    public Set<String> keys() {
        if (null == this.keys) {
            RequestMessage msg = RequestMessage.build("keys").addArg("sideEffect", this.serverSideEffect).addArg("host", this.host).processor("traversal").create();
            try {
                this.keys = this.client.submitAsync(msg).get().all().get().stream().map(r -> r.getString()).collect(Collectors.toSet());
            }
            catch (Exception ex) {
                Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
                if (root.getMessage().equals("Could not find side-effects for " + this.serverSideEffect + ".")) {
                    this.keys = Collections.emptySet();
                }
                throw new RuntimeException("Could not get keys", root);
            }
        }
        return this.keys;
    }
}

