/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Connection;
import org.apache.tinkerpop.gremlin.driver.ConnectionPool;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.util.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Client {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    protected final Cluster cluster;
    protected volatile boolean initialized;
    protected final Settings settings;

    Client(Cluster cluster, Settings settings) {
        this.cluster = cluster;
        this.settings = settings;
    }

    public RequestMessage.Builder buildMessage(RequestMessage.Builder builder) {
        return builder;
    }

    protected abstract void initializeImplementation();

    protected abstract Connection chooseConnection(RequestMessage var1) throws TimeoutException, ConnectionException;

    public abstract CompletableFuture<Void> closeAsync();

    @Deprecated
    public Client rebind(String graphOrTraversalSource) {
        return this.alias(graphOrTraversalSource);
    }

    public Client alias(String graphOrTraversalSource) {
        return this.alias(this.makeDefaultAliasMap(graphOrTraversalSource));
    }

    @Deprecated
    public Client rebind(Map<String, String> rebindings) {
        return this.alias(rebindings);
    }

    public Client alias(Map<String, String> aliases) {
        return new AliasClusteredClient(this, aliases, this.settings);
    }

    public ResultSet submit(Traversal traversal) {
        try {
            return this.submitAsync(traversal).get();
        }
        catch (UnsupportedOperationException uoe) {
            throw uoe;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public CompletableFuture<ResultSet> submitAsync(Traversal traversal) {
        throw new UnsupportedOperationException("This implementation does not support Traversal submission - use a sessionless Client created with from the alias() method");
    }

    public synchronized Client init() {
        if (this.initialized) {
            return this;
        }
        logger.debug("Initializing client on cluster [{}]", (Object)this.cluster);
        this.cluster.init();
        this.initializeImplementation();
        this.initialized = true;
        return this;
    }

    public ResultSet submit(String gremlin) {
        return this.submit(gremlin, null);
    }

    public ResultSet submit(String gremlin, Map<String, Object> parameters) {
        try {
            return this.submitAsync(gremlin, parameters).get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public CompletableFuture<ResultSet> submitAsync(String gremlin) {
        return this.submitAsync(gremlin, null);
    }

    public CompletableFuture<ResultSet> submitAsync(String gremlin, Map<String, Object> parameters) {
        RequestMessage.Builder request = RequestMessage.build("eval").add("gremlin", gremlin).add("batchSize", this.cluster.connectionPoolSettings().resultIterationBatchSize);
        Optional.ofNullable(parameters).ifPresent(params -> request.addArg("bindings", parameters));
        return this.submitAsync(this.buildMessage(request).create());
    }

    public CompletableFuture<ResultSet> submitAsync(String gremlin, String graphOrTraversalSource, Map<String, Object> parameters) {
        RequestMessage.Builder request = RequestMessage.build("eval").add("gremlin", gremlin).add("batchSize", this.cluster.connectionPoolSettings().resultIterationBatchSize);
        Optional.ofNullable(parameters).ifPresent(params -> request.addArg("bindings", parameters));
        if (graphOrTraversalSource != null && !graphOrTraversalSource.isEmpty()) {
            request.addArg("aliases", this.makeDefaultAliasMap(graphOrTraversalSource));
        }
        return this.submitAsync(this.buildMessage(request).create());
    }

    public CompletableFuture<ResultSet> submitAsync(String gremlin, Map<String, String> aliases, Map<String, Object> parameters) {
        RequestMessage.Builder request = RequestMessage.build("eval").add("gremlin", gremlin).add("batchSize", this.cluster.connectionPoolSettings().resultIterationBatchSize);
        Optional.ofNullable(parameters).ifPresent(params -> request.addArg("bindings", parameters));
        if (aliases != null && !aliases.isEmpty()) {
            request.addArg("aliases", aliases);
        }
        return this.submitAsync(this.buildMessage(request).create());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<ResultSet> submitAsync(RequestMessage msg) {
        CompletableFuture<ResultSet> completableFuture;
        if (!this.initialized) {
            this.init();
        }
        CompletableFuture<ResultSet> future = new CompletableFuture<ResultSet>();
        Connection connection = null;
        try {
            connection = this.chooseConnection(msg);
            connection.write(msg, future);
            completableFuture = future;
        }
        catch (TimeoutException toe) {
            try {
                throw new RuntimeException(toe);
                catch (ConnectionException ce) {
                    throw new RuntimeException(ce);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Submitted {} to - {}", (Object)msg, (Object)(null == connection ? "connection not initialized" : connection.toString()));
                }
                throw throwable;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Submitted {} to - {}", (Object)msg, (Object)(null == connection ? "connection not initialized" : connection.toString()));
        }
        return completableFuture;
    }

    public void close() {
        this.closeAsync().join();
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    protected Map<String, String> makeDefaultAliasMap(String graphOrTraversalSource) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("g", graphOrTraversalSource);
        return aliases;
    }

    public static class SessionSettings {
        private final boolean manageTransactions;
        private final String sessionId;

        private SessionSettings(Builder builder) {
            this.manageTransactions = builder.manageTransactions;
            this.sessionId = builder.sessionId;
        }

        public boolean manageTransactions() {
            return this.manageTransactions;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public static Builder build() {
            return new Builder();
        }

        public static class Builder {
            private boolean manageTransactions = false;
            private String sessionId = UUID.randomUUID().toString();

            private Builder() {
            }

            public Builder manageTransactions(boolean manage) {
                this.manageTransactions = manage;
                return this;
            }

            public Builder sessionId(String sessionId) {
                if (null == sessionId || sessionId.isEmpty()) {
                    throw new IllegalArgumentException("sessionId cannot be null or empty");
                }
                this.sessionId = sessionId;
                return this;
            }

            public SessionSettings create() {
                return new SessionSettings(this);
            }
        }
    }

    public static class Settings {
        private final boolean unrollTraversers;
        private final Optional<SessionSettings> session;

        private Settings(Builder builder) {
            this.unrollTraversers = builder.unrollTraversers;
            this.session = builder.session;
        }

        public static Builder build() {
            return new Builder();
        }

        public boolean unrollTraversers() {
            return this.unrollTraversers;
        }

        public Optional<SessionSettings> getSession() {
            return this.session;
        }

        public static class Builder {
            private boolean unrollTraversers = true;
            private Optional<SessionSettings> session = Optional.empty();

            private Builder() {
            }

            public Builder unrollTraversers(boolean unrollTraversers) {
                this.unrollTraversers = unrollTraversers;
                return this;
            }

            public Builder useSession(boolean enabled) {
                this.session = enabled ? Optional.of(SessionSettings.build().create()) : Optional.empty();
                return this;
            }

            public Builder useSession(String sessionId) {
                this.session = sessionId != null && !sessionId.isEmpty() ? Optional.of(SessionSettings.build().sessionId(sessionId).create()) : Optional.empty();
                return this;
            }

            public Builder useSession(SessionSettings settings) {
                this.session = Optional.ofNullable(settings);
                return this;
            }

            public Settings create() {
                return new Settings(this);
            }
        }
    }

    public static final class SessionedClient
    extends Client {
        private final String sessionId;
        private final boolean manageTransactions;
        private ConnectionPool connectionPool;

        SessionedClient(Cluster cluster, Settings settings) {
            super(cluster, settings);
            this.sessionId = settings.getSession().get().sessionId;
            this.manageTransactions = settings.getSession().get().manageTransactions;
        }

        String getSessionId() {
            return this.sessionId;
        }

        @Override
        public RequestMessage.Builder buildMessage(RequestMessage.Builder builder) {
            builder.processor("session");
            builder.addArg("session", this.sessionId);
            builder.addArg("manageTransaction", this.manageTransactions);
            return builder;
        }

        @Override
        protected Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
            return this.connectionPool.borrowConnection(this.cluster.connectionPoolSettings().maxWaitForConnection, TimeUnit.MILLISECONDS);
        }

        @Override
        protected void initializeImplementation() {
            List hosts = this.cluster.allHosts().stream().filter(Host::isAvailable).collect(Collectors.toList());
            Collections.shuffle(hosts);
            Host host = (Host)hosts.get(0);
            this.connectionPool = new ConnectionPool(host, this, Optional.of(1), Optional.of(1));
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            return this.connectionPool.closeAsync();
        }
    }

    @Deprecated
    public static class ReboundClusteredClient
    extends Client {
        private final Client client;
        private final Map<String, String> aliases = new HashMap<String, String>();
        final CompletableFuture<Void> close = new CompletableFuture();

        ReboundClusteredClient(Client client, Map<String, String> rebindings, Settings settings) {
            super(client.cluster, settings);
            this.client = client;
            this.aliases.putAll(rebindings);
        }

        @Override
        public CompletableFuture<ResultSet> submitAsync(Traversal traversal) {
            byte[] serializedTraversal;
            try {
                serializedTraversal = Serializer.serializeObject((Object)traversal);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            try {
                return this.submitAsync(this.buildMessage(RequestMessage.build("traverse").processor("traversal").addArg("gremlin", serializedTraversal)).create());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public synchronized Client init() {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            this.client.init();
            return this;
        }

        @Override
        public RequestMessage.Builder buildMessage(RequestMessage.Builder builder) {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            if (!this.aliases.isEmpty()) {
                builder.addArg("aliases", this.aliases);
            }
            return this.client.buildMessage(builder);
        }

        @Override
        protected void initializeImplementation() {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
        }

        @Override
        protected Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            return this.client.chooseConnection(msg);
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            this.close.complete(null);
            return this.close;
        }

        @Override
        @Deprecated
        public Client rebind(String graphOrTraversalSource) {
            return this.alias(graphOrTraversalSource);
        }

        @Override
        public Client alias(Map<String, String> aliases) {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            return new AliasClusteredClient(this.client, aliases, this.settings);
        }
    }

    public static final class AliasClusteredClient
    extends ReboundClusteredClient {
        public AliasClusteredClient(Client client, Map<String, String> rebindings, Settings settings) {
            super(client, rebindings, settings);
        }
    }

    public static final class ClusteredClient
    extends Client {
        private ConcurrentMap<Host, ConnectionPool> hostConnectionPools = new ConcurrentHashMap<Host, ConnectionPool>();

        ClusteredClient(Cluster cluster, Settings settings) {
            super(cluster, settings);
        }

        public ResultSet submit(String gremlin, String graphOrTraversalSource) {
            return this.submit(gremlin, graphOrTraversalSource, null);
        }

        public ResultSet submit(String gremlin, String graphOrTraversalSource, Map<String, Object> parameters) {
            try {
                return this.submitAsync(gremlin, graphOrTraversalSource, parameters).get();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public CompletableFuture<ResultSet> submitAsync(String gremlin, String graphOrTraversalSource, Map<String, Object> parameters) {
            RequestMessage.Builder request = RequestMessage.build("eval").add("gremlin", gremlin).add("batchSize", this.cluster.connectionPoolSettings().resultIterationBatchSize);
            Optional.ofNullable(parameters).ifPresent(params -> request.addArg("bindings", parameters));
            if (graphOrTraversalSource != null && !graphOrTraversalSource.isEmpty()) {
                request.addArg("aliases", this.makeDefaultAliasMap(graphOrTraversalSource));
            }
            return this.submitAsync(this.buildMessage(request).create());
        }

        @Override
        public CompletableFuture<ResultSet> submitAsync(String gremlin, Map<String, String> aliases, Map<String, Object> parameters) {
            RequestMessage.Builder request = RequestMessage.build("eval").add("gremlin", gremlin).add("batchSize", this.cluster.connectionPoolSettings().resultIterationBatchSize);
            Optional.ofNullable(parameters).ifPresent(params -> request.addArg("bindings", parameters));
            if (aliases != null && !aliases.isEmpty()) {
                request.addArg("aliases", aliases);
            }
            return this.submitAsync(this.buildMessage(request).create());
        }

        @Override
        @Deprecated
        public Client rebind(String graphOrTraversalSource) {
            return this.alias(graphOrTraversalSource);
        }

        @Override
        public Client alias(String graphOrTraversalSource) {
            HashMap<String, String> aliases = new HashMap<String, String>();
            aliases.put("g", graphOrTraversalSource);
            return this.alias(aliases);
        }

        @Override
        @Deprecated
        public Client rebind(Map<String, String> rebindings) {
            return this.alias(rebindings);
        }

        @Override
        public Client alias(Map<String, String> aliases) {
            return new AliasClusteredClient(this, aliases, this.settings);
        }

        @Override
        protected Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
            Iterator<Host> possibleHosts = this.cluster.loadBalancingStrategy().select(msg);
            if (!possibleHosts.hasNext()) {
                throw new TimeoutException("Timed out while waiting for an available host - check the client configuration and connectivity to the server if this message persists");
            }
            Host bestHost = possibleHosts.next();
            ConnectionPool pool = (ConnectionPool)this.hostConnectionPools.get(bestHost);
            return pool.borrowConnection(this.cluster.connectionPoolSettings().maxWaitForConnection, TimeUnit.MILLISECONDS);
        }

        @Override
        protected void initializeImplementation() {
            this.cluster.allHosts().forEach(host -> {
                try {
                    this.hostConnectionPools.put((Host)host, new ConnectionPool((Host)host, this));
                    this.cluster.loadBalancingStrategy().onNew((Host)host);
                }
                catch (Exception ex) {
                    logger.warn("Could not initialize connection pool for {} - will try later", host);
                }
            });
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            CompletableFuture[] poolCloseFutures = new CompletableFuture[this.hostConnectionPools.size()];
            this.hostConnectionPools.values().stream().map(ConnectionPool::closeAsync).collect(Collectors.toList()).toArray(poolCloseFutures);
            return CompletableFuture.allOf(poolCloseFutures);
        }
    }
}

