/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.driver.AuthProperties;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.LoadBalancingStrategy;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.Settings;
import org.apache.tinkerpop.gremlin.driver.ser.Serializers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cluster {
    private static final Logger logger = LoggerFactory.getLogger(Cluster.class);
    private Manager manager;

    private Cluster(Builder builder) {
        this.manager = new Manager(builder);
    }

    public synchronized void init() {
        if (!this.manager.initialized) {
            this.manager.init();
        }
    }

    public <T extends Client> T connect() {
        return (T)new Client.ClusteredClient(this);
    }

    public <T extends Client> T connect(String sessionId) {
        return this.connect(sessionId, false);
    }

    public <T extends Client> T connect(String sessionId, boolean manageTransactions) {
        if (null == sessionId || sessionId.isEmpty()) {
            throw new IllegalArgumentException("sessionId cannot be null or empty");
        }
        return (T)new Client.SessionedClient(this, sessionId, manageTransactions);
    }

    public String toString() {
        return this.manager.toString();
    }

    public static Builder build() {
        return new Builder();
    }

    public static Builder build(String address) {
        return new Builder(address);
    }

    public static Builder build(File configurationFile) throws FileNotFoundException {
        Settings settings = Settings.read(new FileInputStream(configurationFile));
        List<String> addresses = settings.hosts;
        if (addresses.size() == 0) {
            throw new IllegalStateException("At least one value must be specified to the hosts setting");
        }
        Builder builder = new Builder(settings.hosts.get(0)).port(settings.port).enableSsl(settings.connectionPool.enableSsl).trustCertificateChainFile(settings.connectionPool.trustCertChainFile).keyCertChainFile(settings.connectionPool.keyCertChainFile).keyFile(settings.connectionPool.keyFile).keyPassword(settings.connectionPool.keyPassword).nioPoolSize(settings.nioPoolSize).workerPoolSize(settings.workerPoolSize).reconnectInterval(settings.connectionPool.reconnectInterval).reconnectIntialDelay(settings.connectionPool.reconnectInitialDelay).resultIterationBatchSize(settings.connectionPool.resultIterationBatchSize).channelizer(settings.connectionPool.channelizer).maxContentLength(settings.connectionPool.maxContentLength).maxWaitForConnection(settings.connectionPool.maxWaitForConnection).maxInProcessPerConnection(settings.connectionPool.maxInProcessPerConnection).minInProcessPerConnection(settings.connectionPool.minInProcessPerConnection).maxSimultaneousUsagePerConnection(settings.connectionPool.maxSimultaneousUsagePerConnection).minSimultaneousUsagePerConnection(settings.connectionPool.minSimultaneousUsagePerConnection).maxConnectionPoolSize(settings.connectionPool.maxSize).minConnectionPoolSize(settings.connectionPool.minSize);
        if (settings.username != null && settings.password != null) {
            builder.credentials(settings.username, settings.password);
        }
        if (settings.jaasEntry != null) {
            builder.jaasEntry(settings.jaasEntry);
        }
        if (settings.protocol != null) {
            builder.protocol(settings.protocol);
        }
        if (addresses.size() > 1) {
            addresses.stream().skip(1L).forEach(builder::addContactPoint);
        }
        try {
            builder.serializer(settings.serializer.create());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not establish serializer - " + ex.getMessage());
        }
        return builder;
    }

    public static Cluster open() {
        return Cluster.build("localhost").create();
    }

    public static Cluster open(String configurationFile) throws Exception {
        File file = new File(configurationFile);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("Configuration file at %s does not exist", configurationFile));
        }
        return Cluster.build(file).create();
    }

    public void close() {
        this.closeAsync().join();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.manager.close();
    }

    public boolean isClosing() {
        return this.manager.isClosing();
    }

    public boolean isClosed() {
        return this.manager.isClosing() && this.manager.close().isDone();
    }

    public List<URI> availableHosts() {
        return Collections.unmodifiableList(this.allHosts().stream().filter(Host::isAvailable).map(Host::getHostUri).collect(Collectors.toList()));
    }

    Factory getFactory() {
        return this.manager.factory;
    }

    MessageSerializer getSerializer() {
        return this.manager.serializer;
    }

    ScheduledExecutorService executor() {
        return this.manager.executor;
    }

    Settings.ConnectionPoolSettings connectionPoolSettings() {
        return this.manager.connectionPoolSettings;
    }

    LoadBalancingStrategy loadBalancingStrategy() {
        return this.manager.loadBalancingStrategy;
    }

    AuthProperties authProperties() {
        return this.manager.authProps;
    }

    Collection<Host> allHosts() {
        return this.manager.allHosts();
    }

    SslContext createSSLContext() throws Exception {
        if (this.manager.sslContextOptional.isPresent()) {
            return (SslContext)this.manager.sslContextOptional.get();
        }
        SslProvider provider = SslProvider.JDK;
        Settings.ConnectionPoolSettings connectionPoolSettings = this.connectionPoolSettings();
        SslContextBuilder builder = SslContextBuilder.forClient();
        if (connectionPoolSettings.trustCertChainFile != null) {
            builder.trustManager(new File(connectionPoolSettings.trustCertChainFile));
        } else {
            logger.warn("SSL configured without a trustCertChainFile and thus trusts all certificates without verification (not suitable for production)");
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        if (null != connectionPoolSettings.keyCertChainFile && null != connectionPoolSettings.keyFile) {
            File keyCertChainFile = new File(connectionPoolSettings.keyCertChainFile);
            File keyFile = new File(connectionPoolSettings.keyFile);
            builder.keyManager(keyCertChainFile, keyFile, connectionPoolSettings.keyPassword);
        }
        builder.sslProvider(provider);
        return builder.build();
    }

    class Manager {
        private final ConcurrentMap<InetSocketAddress, Host> hosts = new ConcurrentHashMap<InetSocketAddress, Host>();
        private boolean initialized;
        private final List<InetSocketAddress> contactPoints;
        private final Factory factory;
        private final MessageSerializer serializer;
        private final Settings.ConnectionPoolSettings connectionPoolSettings;
        private final LoadBalancingStrategy loadBalancingStrategy;
        private final AuthProperties authProps;
        private final Optional<SslContext> sslContextOptional;
        private final ScheduledExecutorService executor;
        private final AtomicReference<CompletableFuture<Void>> closeFuture = new AtomicReference();

        private Manager(Builder builder) {
            this.loadBalancingStrategy = builder.loadBalancingStrategy;
            this.authProps = builder.authProps;
            this.contactPoints = builder.getContactPoints();
            this.connectionPoolSettings = new Settings.ConnectionPoolSettings();
            this.connectionPoolSettings.maxInProcessPerConnection = builder.maxInProcessPerConnection;
            this.connectionPoolSettings.minInProcessPerConnection = builder.minInProcessPerConnection;
            this.connectionPoolSettings.maxSimultaneousUsagePerConnection = builder.maxSimultaneousUsagePerConnection;
            this.connectionPoolSettings.minSimultaneousUsagePerConnection = builder.minSimultaneousUsagePerConnection;
            this.connectionPoolSettings.maxSize = builder.maxConnectionPoolSize;
            this.connectionPoolSettings.minSize = builder.minConnectionPoolSize;
            this.connectionPoolSettings.maxWaitForConnection = builder.maxWaitForConnection;
            this.connectionPoolSettings.maxWaitForSessionClose = builder.maxWaitForSessionClose;
            this.connectionPoolSettings.maxContentLength = builder.maxContentLength;
            this.connectionPoolSettings.reconnectInitialDelay = builder.reconnectInitialDelay;
            this.connectionPoolSettings.reconnectInterval = builder.reconnectInterval;
            this.connectionPoolSettings.resultIterationBatchSize = builder.resultIterationBatchSize;
            this.connectionPoolSettings.enableSsl = builder.enableSsl;
            this.connectionPoolSettings.trustCertChainFile = builder.trustCertChainFile;
            this.connectionPoolSettings.keyCertChainFile = builder.keyCertChainFile;
            this.connectionPoolSettings.keyFile = builder.keyFile;
            this.connectionPoolSettings.keyPassword = builder.keyPassword;
            this.connectionPoolSettings.channelizer = builder.channelizer;
            this.sslContextOptional = Optional.ofNullable(builder.sslContext);
            this.factory = new Factory(builder.nioPoolSize);
            this.serializer = builder.serializer;
            this.executor = Executors.newScheduledThreadPool(builder.workerPoolSize, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("gremlin-driver-worker-%d").build());
        }

        synchronized void init() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            this.contactPoints.forEach(address -> {
                Host host = this.add((InetSocketAddress)address);
                if (host != null) {
                    host.makeAvailable();
                }
            });
        }

        public Host add(InetSocketAddress address) {
            Host newHost = new Host(address, Cluster.this);
            Host previous = this.hosts.putIfAbsent(address, newHost);
            return previous == null ? newHost : null;
        }

        Collection<Host> allHosts() {
            return this.hosts.values();
        }

        synchronized CompletableFuture<Void> close() {
            if (this.closeFuture.get() != null) {
                return this.closeFuture.get();
            }
            CompletableFuture<Void> closeIt = new CompletableFuture<Void>();
            this.closeFuture.set(closeIt);
            Cluster.this.executor().submit(() -> {
                this.factory.shutdown();
                closeIt.complete(null);
            });
            this.executor.shutdown();
            return closeIt;
        }

        boolean isClosing() {
            return this.closeFuture.get() != null;
        }

        public String toString() {
            return String.join((CharSequence)", ", this.contactPoints.stream().map(InetSocketAddress::toString).collect(Collectors.toList()));
        }
    }

    static class Factory {
        private final EventLoopGroup group;

        public Factory(int nioPoolSize) {
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("gremlin-driver-loop-%d").build();
            this.group = new NioEventLoopGroup(nioPoolSize, (ThreadFactory)threadFactory);
        }

        Bootstrap createBootstrap() {
            Bootstrap b = (Bootstrap)new Bootstrap().group(this.group);
            b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            return b;
        }

        void shutdown() {
            this.group.shutdownGracefully().awaitUninterruptibly();
        }
    }

    public static final class Builder {
        private List<InetAddress> addresses = new ArrayList<InetAddress>();
        private int port = 8182;
        private MessageSerializer serializer = Serializers.GRYO_V1D0.simpleInstance();
        private int nioPoolSize = Runtime.getRuntime().availableProcessors();
        private int workerPoolSize = Runtime.getRuntime().availableProcessors() * 2;
        private int minConnectionPoolSize = 2;
        private int maxConnectionPoolSize = 8;
        private int minSimultaneousUsagePerConnection = 8;
        private int maxSimultaneousUsagePerConnection = 16;
        private int maxInProcessPerConnection = 4;
        private int minInProcessPerConnection = 1;
        private int maxWaitForConnection = 3000;
        private int maxWaitForSessionClose = 3000;
        private int maxContentLength = 65536;
        private int reconnectInitialDelay = 1000;
        private int reconnectInterval = 1000;
        private int resultIterationBatchSize = 64;
        private String channelizer = Channelizer.WebSocketChannelizer.class.getName();
        private boolean enableSsl = false;
        private String trustCertChainFile = null;
        private String keyCertChainFile = null;
        private String keyFile = null;
        private String keyPassword = null;
        private SslContext sslContext = null;
        private LoadBalancingStrategy loadBalancingStrategy = new LoadBalancingStrategy.RoundRobin();
        private AuthProperties authProps = new AuthProperties();

        private Builder() {
        }

        private Builder(String address) {
            this.addContactPoint(address);
        }

        public Builder nioPoolSize(int nioPoolSize) {
            if (nioPoolSize < 1) {
                throw new IllegalArgumentException("The workerPoolSize must be greater than zero");
            }
            this.nioPoolSize = nioPoolSize;
            return this;
        }

        public Builder workerPoolSize(int workerPoolSize) {
            if (workerPoolSize < 1) {
                throw new IllegalArgumentException("The workerPoolSize must be greater than zero");
            }
            this.workerPoolSize = workerPoolSize;
            return this;
        }

        public Builder serializer(String mimeType) {
            this.serializer = Serializers.valueOf(mimeType).simpleInstance();
            return this;
        }

        public Builder serializer(Serializers mimeType) {
            this.serializer = mimeType.simpleInstance();
            return this;
        }

        public Builder serializer(MessageSerializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder enableSsl(boolean enable) {
            this.enableSsl = enable;
            return this;
        }

        public Builder sslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder trustCertificateChainFile(String certificateChainFile) {
            this.trustCertChainFile = certificateChainFile;
            return this;
        }

        public Builder keyCertChainFile(String keyCertChainFile) {
            this.keyCertChainFile = keyCertChainFile;
            return this;
        }

        public Builder keyFile(String keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        public Builder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder minInProcessPerConnection(int minInProcessPerConnection) {
            this.minInProcessPerConnection = minInProcessPerConnection;
            return this;
        }

        public Builder maxInProcessPerConnection(int maxInProcessPerConnection) {
            this.maxInProcessPerConnection = maxInProcessPerConnection;
            return this;
        }

        public Builder maxSimultaneousUsagePerConnection(int maxSimultaneousUsagePerConnection) {
            this.maxSimultaneousUsagePerConnection = maxSimultaneousUsagePerConnection;
            return this;
        }

        public Builder minSimultaneousUsagePerConnection(int minSimultaneousUsagePerConnection) {
            this.minSimultaneousUsagePerConnection = minSimultaneousUsagePerConnection;
            return this;
        }

        public Builder maxConnectionPoolSize(int maxSize) {
            this.maxConnectionPoolSize = maxSize;
            return this;
        }

        public Builder minConnectionPoolSize(int minSize) {
            this.minConnectionPoolSize = minSize;
            return this;
        }

        public Builder resultIterationBatchSize(int size) {
            this.resultIterationBatchSize = size;
            return this;
        }

        public Builder maxWaitForConnection(int maxWait) {
            this.maxWaitForConnection = maxWait;
            return this;
        }

        public Builder maxWaitForSessionClose(int maxWait) {
            this.maxWaitForSessionClose = maxWait;
            return this;
        }

        public Builder maxContentLength(int maxContentLength) {
            this.maxContentLength = maxContentLength;
            return this;
        }

        public Builder channelizer(String channelizerClass) {
            this.channelizer = channelizerClass;
            return this;
        }

        public Builder channelizer(Class channelizerClass) {
            return this.channelizer(channelizerClass.getCanonicalName());
        }

        public Builder reconnectIntialDelay(int initialDelay) {
            this.reconnectInitialDelay = initialDelay;
            return this;
        }

        public Builder reconnectInterval(int interval) {
            this.reconnectInterval = interval;
            return this;
        }

        public Builder loadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
            this.loadBalancingStrategy = loadBalancingStrategy;
            return this;
        }

        public Builder authProperties(AuthProperties authProps) {
            this.authProps = authProps;
            return this;
        }

        public Builder credentials(String username, String password) {
            this.authProps = this.authProps.with(AuthProperties.Property.USERNAME, username).with(AuthProperties.Property.PASSWORD, password);
            return this;
        }

        public Builder protocol(String protocol) {
            this.authProps = this.authProps.with(AuthProperties.Property.PROTOCOL, protocol);
            return this;
        }

        public Builder jaasEntry(String jaasEntry) {
            this.authProps = this.authProps.with(AuthProperties.Property.JAAS_ENTRY, jaasEntry);
            return this;
        }

        public Builder addContactPoint(String address) {
            try {
                this.addresses.add(InetAddress.getByName(address));
                return this;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public Builder addContactPoints(String ... addresses) {
            for (String address : addresses) {
                this.addContactPoint(address);
            }
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        List<InetSocketAddress> getContactPoints() {
            return this.addresses.stream().map(addy -> new InetSocketAddress((InetAddress)addy, this.port)).collect(Collectors.toList());
        }

        public Cluster create() {
            if (this.addresses.size() == 0) {
                this.addContactPoint("localhost");
            }
            return new Cluster(this);
        }
    }
}

