/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;

public interface LoadBalancingStrategy
extends Host.Listener {
    public void initialize(Cluster var1, Collection<Host> var2);

    public Iterator<Host> select(RequestMessage var1);

    public static class RoundRobin
    implements LoadBalancingStrategy {
        private final CopyOnWriteArrayList<Host> availableHosts = new CopyOnWriteArrayList();
        private final AtomicInteger index = new AtomicInteger();

        @Override
        public void initialize(Cluster cluster, Collection<Host> hosts) {
            this.availableHosts.addAll(hosts);
            this.index.set(new Random().nextInt(Math.max(hosts.size(), 1)));
        }

        @Override
        public Iterator<Host> select(RequestMessage msg) {
            final List hosts = (List)this.availableHosts.clone();
            final int startIndex = this.index.getAndIncrement();
            if (startIndex > 2147473647) {
                this.index.set(0);
            }
            return new Iterator<Host>(){
                private int currentIndex;
                private int remainingHosts;
                {
                    this.currentIndex = startIndex;
                    this.remainingHosts = hosts.size();
                }

                @Override
                public boolean hasNext() {
                    return this.remainingHosts > 0;
                }

                @Override
                public Host next() {
                    int c;
                    --this.remainingHosts;
                    if ((c = this.currentIndex++ % hosts.size()) < 0) {
                        c += hosts.size();
                    }
                    return (Host)hosts.get(c);
                }
            };
        }

        @Override
        public void onAvailable(Host host) {
            this.availableHosts.addIfAbsent(host);
        }

        @Override
        public void onUnavailable(Host host) {
            this.availableHosts.remove(host);
        }

        @Override
        public void onNew(Host host) {
            this.onAvailable(host);
        }

        @Override
        public void onRemove(Host host) {
            this.onUnavailable(host);
        }
    }
}

