/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultQueue;

public final class ResultSet
implements Iterable<Result> {
    private final ResultQueue resultQueue;
    private final ExecutorService executor;
    private final CompletableFuture<Void> readCompleted;

    public ResultSet(ResultQueue resultQueue, ExecutorService executor, CompletableFuture<Void> readCompleted) {
        this.executor = executor;
        this.resultQueue = resultQueue;
        this.readCompleted = readCompleted;
    }

    public boolean allItemsAvailable() {
        return this.readCompleted.isDone();
    }

    public int getAvailableItemCount() {
        return this.resultQueue.size();
    }

    public Result one() {
        List<Result> results = this.some(1).join();
        assert (results.size() <= 1);
        return results.size() == 1 ? results.get(0) : null;
    }

    public CompletableFuture<List<Result>> some(int items) {
        return this.resultQueue.await(items);
    }

    public CompletableFuture<List<Result>> all() {
        return this.readCompleted.thenApplyAsync(it -> {
            ArrayList<Result> list = new ArrayList<Result>();
            this.resultQueue.drainTo(list);
            return list;
        }, (Executor)this.executor);
    }

    public Stream<Result> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1088), false);
    }

    @Override
    public Iterator<Result> iterator() {
        return new Iterator<Result>(){
            private Result nextOne = null;

            @Override
            public boolean hasNext() {
                List<Result> list = ResultSet.this.some(1).join();
                assert (list.size() <= 1);
                this.nextOne = list.size() == 0 ? null : list.get(0);
                return this.nextOne != null;
            }

            @Override
            public Result next() {
                if (null != this.nextOne || this.hasNext()) {
                    Result r = this.nextOne;
                    this.nextOne = null;
                    return r;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

