/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ser.Serializers;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;

public class ProfilingApplication {
    private final Cluster cluster;
    private final int requests;
    private final String executionName;
    private final String script;
    private final int tooSlowThreshold;
    private final ExecutorService executor;

    public ProfilingApplication(String executionName, Cluster cluster, int requests, ExecutorService executor, String script, int tooSlowThreshold) {
        this.executionName = executionName;
        this.cluster = cluster;
        this.requests = requests;
        this.executor = executor;
        this.script = script;
        this.tooSlowThreshold = tooSlowThreshold;
    }

    public long execute() throws Exception {
        AtomicInteger tooSlow = new AtomicInteger(0);
        String executionId = "[" + this.executionName + "]";
        try (Client client = this.cluster.connect();){
            CountDownLatch latch = new CountDownLatch(this.requests);
            client.init();
            long start = System.nanoTime();
            IntStream.range(0, this.requests).forEach(i -> client.submitAsync(this.script).thenAcceptAsync(r -> {
                try {
                    r.all().get(this.tooSlowThreshold, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ex) {
                    tooSlow.incrementAndGet();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    latch.countDown();
                }
            }, (Executor)this.executor));
            latch.await();
            long end = System.nanoTime();
            long total = end - start;
            double totalSeconds = (double)total / 1.0E9;
            long requestCount = this.requests;
            long reqSec = Math.round((double)requestCount / totalSeconds);
            System.out.println(String.format(StringUtils.rightPad((String)executionId, (int)10) + " requests: %s | time(s): %s | req/sec: %s | too slow: %s", requestCount, StringUtils.rightPad((String)String.valueOf(totalSeconds), (int)14), StringUtils.rightPad((String)String.valueOf(reqSec), (int)7), tooSlow.get()));
            long l = reqSec;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Map options = ElementHelper.asMap((Object[])args);
        boolean noExit = Boolean.parseBoolean(options.getOrDefault("noExit", "false").toString());
        int parallelism = Integer.parseInt(options.getOrDefault("parallelism", "16").toString());
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("profiler-%d").build();
        ExecutorService executor = Executors.newFixedThreadPool(parallelism, (ThreadFactory)threadFactory);
        String host = options.getOrDefault("host", "localhost").toString();
        int minExpectedRps = Integer.parseInt(options.getOrDefault("minExpectedRps", "1000").toString());
        int timeout = Integer.parseInt(options.getOrDefault("timeout", "1200000").toString());
        int warmups = Integer.parseInt(options.getOrDefault("warmups", "5").toString());
        int executions = Integer.parseInt(options.getOrDefault("executions", "10").toString());
        int nioPoolSize = Integer.parseInt(options.getOrDefault("nioPoolSize", "1").toString());
        int requests = Integer.parseInt(options.getOrDefault("requests", "10000").toString());
        int minConnectionPoolSize = Integer.parseInt(options.getOrDefault("minConnectionPoolSize", "256").toString());
        int maxConnectionPoolSize = Integer.parseInt(options.getOrDefault("maxConnectionPoolSize", "256").toString());
        int minSimultaneousUsagePerConnection = Integer.parseInt(options.getOrDefault("minSimultaneousUsagePerConnection", "8").toString());
        int maxSimultaneousUsagePerConnection = Integer.parseInt(options.getOrDefault("maxSimultaneousUsagePerConnection", "32").toString());
        int maxInProcessPerConnection = Integer.parseInt(options.getOrDefault("maxInProcessPerConnection", "64").toString());
        int minInProcessPerConnection = Integer.parseInt(options.getOrDefault("minInProcessPerConnection", "16").toString());
        int maxWaitForConnection = Integer.parseInt(options.getOrDefault("maxWaitForConnection", "3000").toString());
        int workerPoolSize = Integer.parseInt(options.getOrDefault("workerPoolSize", "2").toString());
        int tooSlowThreshold = Integer.parseInt(options.getOrDefault("tooSlowThreshold", "125").toString());
        String serializer = options.getOrDefault("serializer", Serializers.GRYO_V1D0.name()).toString();
        String script = options.getOrDefault("script", "1+1").toString();
        Cluster cluster = Cluster.build(host).minConnectionPoolSize(minConnectionPoolSize).maxConnectionPoolSize(maxConnectionPoolSize).minSimultaneousUsagePerConnection(minSimultaneousUsagePerConnection).maxSimultaneousUsagePerConnection(maxSimultaneousUsagePerConnection).minInProcessPerConnection(minInProcessPerConnection).maxInProcessPerConnection(maxInProcessPerConnection).nioPoolSize(nioPoolSize).maxWaitForConnection(maxWaitForConnection).serializer(Serializers.valueOf(serializer)).workerPoolSize(workerPoolSize).create();
        try {
            File f;
            Object fileName = options.get("store");
            File file = f = null == fileName ? null : new File(fileName.toString());
            if (f != null && f.length() == 0L) {
                try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));){
                    writer.println("parallelism\tnioPoolSize\tminConnectionPoolSize\tmaxConnectionPoolSize\tminSimultaneousUsagePerConnection\tmaxSimultaneousUsagePerConnection\tminInProcessPerConnection\tmaxInProcessPerConnection\tworkerPoolSize\trequestPerSecond");
                }
            }
            AtomicBoolean meetsRpsExpectation = new AtomicBoolean(true);
            System.out.println("---------------------------WARMUP CYCLE---------------------------");
            for (int ix = 0; ix < warmups && meetsRpsExpectation.get(); ++ix) {
                long averageRequestsPerSecond = new ProfilingApplication("warmup-" + (ix + 1), cluster, 1000, executor, script, tooSlowThreshold).execute();
                meetsRpsExpectation.set(averageRequestsPerSecond > (long)minExpectedRps);
                TimeUnit.SECONDS.sleep(1L);
            }
            AtomicBoolean exceededTimeout = new AtomicBoolean(false);
            long totalRequestsPerSecond = 0L;
            if (meetsRpsExpectation.get()) {
                long start = System.nanoTime();
                System.out.println("----------------------------TEST CYCLE----------------------------");
                for (int ix = 0; ix < executions && !exceededTimeout.get(); ++ix) {
                    totalRequestsPerSecond += new ProfilingApplication("test-" + (ix + 1), cluster, requests, executor, script, tooSlowThreshold).execute();
                    exceededTimeout.set(System.nanoTime() - start > TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS));
                    TimeUnit.SECONDS.sleep(1L);
                }
            }
            int averageRequestPerSecond = !meetsRpsExpectation.get() || exceededTimeout.get() ? 0 : Math.round(totalRequestsPerSecond / (long)executions);
            System.out.println(String.format("avg req/sec: %s", averageRequestPerSecond));
            if (f != null) {
                try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));){
                    writer.println(String.join((CharSequence)"\t", String.valueOf(parallelism), String.valueOf(nioPoolSize), String.valueOf(minConnectionPoolSize), String.valueOf(maxConnectionPoolSize), String.valueOf(minSimultaneousUsagePerConnection), String.valueOf(maxSimultaneousUsagePerConnection), String.valueOf(minInProcessPerConnection), String.valueOf(maxInProcessPerConnection), String.valueOf(workerPoolSize), String.valueOf(averageRequestPerSecond)));
                }
            }
            if (!noExit) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (!noExit) {
                System.exit(1);
            }
        }
        finally {
            executor.shutdown();
            cluster.close();
        }
    }
}

