/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.simple;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.driver.handler.NioGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.NioGremlinResponseDecoder;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.driver.simple.SimpleClient;

public class NioClient
implements SimpleClient {
    private final Channel channel;
    private final EventLoopGroup group;
    private final CallbackResponseHandler callbackResponseHandler = new CallbackResponseHandler();

    public NioClient() {
        this(URI.create("gs://localhost:8182"));
    }

    public NioClient(URI uri) {
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("nio-client-%d").build();
        this.group = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors(), (ThreadFactory)threadFactory);
        Bootstrap b = (Bootstrap)new Bootstrap().group(this.group);
        b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        try {
            final GryoMessageSerializerV1d0 serializer = new GryoMessageSerializerV1d0();
            ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new NioGremlinResponseDecoder(serializer), new NioGremlinRequestEncoder(true, serializer), NioClient.this.callbackResponseHandler});
                }
            });
            this.channel = b.connect(uri.getHost(), uri.getPort()).sync().channel();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void submit(RequestMessage requestMessage, Consumer<ResponseMessage> callback) throws Exception {
        this.callbackResponseHandler.callback = callback;
        this.channel.writeAndFlush((Object)requestMessage).get();
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close().get();
        }
        catch (Exception exception) {
        }
        finally {
            this.group.shutdownGracefully().awaitUninterruptibly();
        }
    }

    static class CallbackResponseHandler
    extends SimpleChannelInboundHandler<ResponseMessage> {
        public Consumer<ResponseMessage> callback;

        CallbackResponseHandler() {
        }

        protected void channelRead0(ChannelHandlerContext channelHandlerContext, ResponseMessage response) throws Exception {
            try {
                this.callback.accept(response);
            }
            finally {
                ReferenceCountUtil.release((Object)response);
            }
        }
    }
}

