/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import groovy.json.JsonBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphSONMessageSerializerV1d0
implements MessageSerializer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGraphSONMessageSerializerV1d0.class);
    protected ObjectMapper mapper;
    protected static final String TOKEN_USE_MAPPER_FROM_GRAPH = "useMapperFromGraph";
    protected final TypeReference<Map<String, Object>> mapTypeReference = new TypeReference<Map<String, Object>>(){};

    public AbstractGraphSONMessageSerializerV1d0() {
        GraphSONMapper.Builder builder = this.configureBuilder(GraphSONMapper.build());
        this.mapper = builder.create().createMapper();
    }

    public AbstractGraphSONMessageSerializerV1d0(GraphSONMapper mapper) {
        this.mapper = mapper.createMapper();
    }

    abstract byte[] obtainHeader();

    abstract GraphSONMapper.Builder configureBuilder(GraphSONMapper.Builder var1);

    @Override
    public void configure(Map<String, Object> config, Map<String, Graph> graphs) {
        GraphSONMapper.Builder initialBuilder;
        Object graphToUseForMapper = config.get(TOKEN_USE_MAPPER_FROM_GRAPH);
        if (graphToUseForMapper != null) {
            if (null == graphs) {
                throw new IllegalStateException(String.format("No graphs have been provided to the serializer and therefore %s is not a valid configuration", TOKEN_USE_MAPPER_FROM_GRAPH));
            }
            Graph g = graphs.get(graphToUseForMapper.toString());
            if (null == g) {
                throw new IllegalStateException(String.format("There is no graph named [%s] configured to be used in the %s setting", graphToUseForMapper, TOKEN_USE_MAPPER_FROM_GRAPH));
            }
            initialBuilder = ((GraphSONIo)g.io(GraphSONIo.build())).mapper();
        } else {
            initialBuilder = GraphSONMapper.build();
        }
        this.mapper = this.configureBuilder(initialBuilder).create().createMapper();
    }

    @Override
    public ByteBuf serializeResponseAsBinary(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            byte[] payload = this.mapper.writeValueAsBytes((Object)responseMessage);
            encodedMessage = allocator.buffer(payload.length);
            encodedMessage.writeBytes(payload);
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn("Response [{}] could not be serialized by {}.", (Object)responseMessage.toString(), (Object)AbstractGraphSONMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public ByteBuf serializeRequestAsBinary(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            byte[] header = this.obtainHeader();
            byte[] payload = this.mapper.writeValueAsBytes((Object)requestMessage);
            encodedMessage = allocator.buffer(header.length + payload.length);
            encodedMessage.writeBytes(header);
            encodedMessage.writeBytes(payload);
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn("Request [{}] could not be serialized by {}.", (Object)requestMessage.toString(), (Object)AbstractGraphSONMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public RequestMessage deserializeRequest(ByteBuf msg) throws SerializationException {
        try {
            byte[] payload = new byte[msg.readableBytes()];
            msg.readBytes(payload);
            return (RequestMessage)this.mapper.readValue(payload, RequestMessage.class);
        }
        catch (Exception ex) {
            logger.warn("Request [{}] could not be deserialized by {}.", (Object)msg, (Object)AbstractGraphSONMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public ResponseMessage deserializeResponse(ByteBuf msg) throws SerializationException {
        try {
            byte[] payload = new byte[msg.readableBytes()];
            msg.readBytes(payload);
            Map responseData = (Map)this.mapper.readValue(payload, this.mapTypeReference);
            Map status = (Map)responseData.get("status");
            Map result = (Map)responseData.get("result");
            return ResponseMessage.build(UUID.fromString(responseData.get("requestId").toString())).code(ResponseStatusCode.getFromValue((Integer)status.get("code"))).statusMessage(status.get("message").toString()).statusAttributes((Map)status.get("attributes")).result(result.get("data")).responseMetaData((Map)result.get("meta")).create();
        }
        catch (Exception ex) {
            logger.warn("Response [{}] could not be deserialized by {}.", (Object)msg, (Object)AbstractGraphSONMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    public static final class ResponseMessageSerializer
    extends StdSerializer<ResponseMessage> {
        public ResponseMessageSerializer() {
            super(ResponseMessage.class);
        }

        public void serialize(ResponseMessage responseMessage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            this.ser(responseMessage, jsonGenerator, serializerProvider, null);
        }

        public void serializeWithType(ResponseMessage responseMessage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            this.ser(responseMessage, jsonGenerator, serializerProvider, typeSerializer);
        }

        public void ser(ResponseMessage responseMessage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartObject();
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@class", HashMap.class.getName());
            }
            jsonGenerator.writeStringField("requestId", responseMessage.getRequestId() != null ? responseMessage.getRequestId().toString() : null);
            jsonGenerator.writeObjectFieldStart("status");
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@class", HashMap.class.getName());
            }
            jsonGenerator.writeStringField("message", responseMessage.getStatus().getMessage());
            jsonGenerator.writeNumberField("code", responseMessage.getStatus().getCode().getValue());
            jsonGenerator.writeObjectField("attributes", responseMessage.getStatus().getAttributes());
            jsonGenerator.writeEndObject();
            jsonGenerator.writeObjectFieldStart("result");
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@class", HashMap.class.getName());
            }
            if (null == responseMessage.getResult().getData()) {
                jsonGenerator.writeNullField("data");
            } else {
                GraphSONUtil.writeWithType((String)"data", (Object)responseMessage.getResult().getData(), (JsonGenerator)jsonGenerator, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            }
            jsonGenerator.writeObjectField("meta", responseMessage.getResult().getMeta());
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }

    public static final class JsonBuilderJacksonSerializer
    extends StdSerializer<JsonBuilder> {
        public JsonBuilderJacksonSerializer() {
            super(JsonBuilder.class);
        }

        public void serialize(JsonBuilder json, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeRaw(":");
            jsonGenerator.writeRaw(json.toString());
            jsonGenerator.writeRaw(",");
        }
    }

    public static final class GremlinServerModule
    extends SimpleModule {
        public GremlinServerModule() {
            super("graphson-gremlin-server");
            this.addSerializer(JsonBuilder.class, (JsonSerializer)new JsonBuilderJacksonSerializer());
            this.addSerializer(ResponseMessage.class, (JsonSerializer)new ResponseMessageSerializer());
        }
    }
}

