/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.javatuples.Pair;

public class GryoMessageSerializerV1d0
implements MessageSerializer {
    private GryoMapper gryoMapper;
    private ThreadLocal<Kryo> kryoThreadLocal = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            return GryoMessageSerializerV1d0.this.gryoMapper.createMapper();
        }
    };
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String MIME_TYPE = "application/vnd.gremlin-v1.0+gryo";
    private static final String MIME_TYPE_STRINGD = "application/vnd.gremlin-v1.0+gryo-stringd";
    private static final String TOKEN_EXTENDED_VERSION = "extendedVersion";
    private static final String TOKEN_CUSTOM = "custom";
    private static final String TOKEN_SERIALIZE_RESULT_TO_STRING = "serializeResultToString";
    private static final String TOKEN_USE_MAPPER_FROM_GRAPH = "useMapperFromGraph";
    private boolean serializeToString;

    public GryoMessageSerializerV1d0() {
        this.gryoMapper = GryoMapper.build((GryoMapper.Version)GryoMapper.Version.V_1_0_0).create();
    }

    public GryoMessageSerializerV1d0(GryoMapper kryo) {
        this.gryoMapper = kryo;
    }

    @Override
    public void configure(Map<String, Object> config, Map<String, Graph> graphs) {
        List classNameList;
        GryoMapper.Builder initialBuilder;
        byte extendedVersion;
        try {
            extendedVersion = Byte.parseByte(config.getOrDefault(TOKEN_EXTENDED_VERSION, (byte)-128).toString());
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Invalid configuration value of [%s] for [%s] setting on %s serialization configuration", config.getOrDefault(TOKEN_EXTENDED_VERSION, ""), TOKEN_EXTENDED_VERSION, this.getClass().getName()), ex);
        }
        Object graphToUseForMapper = config.get(TOKEN_USE_MAPPER_FROM_GRAPH);
        if (graphToUseForMapper != null) {
            if (null == graphs) {
                throw new IllegalStateException(String.format("No graphs have been provided to the serializer and therefore %s is not a valid configuration", TOKEN_USE_MAPPER_FROM_GRAPH));
            }
            Graph g = graphs.get(graphToUseForMapper.toString());
            if (null == g) {
                throw new IllegalStateException(String.format("There is no graph named [%s] configured to be used in the %s setting", graphToUseForMapper, TOKEN_USE_MAPPER_FROM_GRAPH));
            }
            initialBuilder = g.io().gryoMapper();
        } else {
            initialBuilder = GryoMapper.build((GryoMapper.Version)GryoMapper.Version.V_1_0_0);
        }
        GryoMapper.Builder builder = initialBuilder.extendedVersion(extendedVersion);
        try {
            classNameList = config.getOrDefault(TOKEN_CUSTOM, new ArrayList());
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Invalid configuration value of [%s] for [%s] setting on %s serialization configuration", config.getOrDefault(TOKEN_CUSTOM, ""), TOKEN_CUSTOM, this.getClass().getName()), ex);
        }
        if (!classNameList.isEmpty()) {
            List<Pair> classList = classNameList.stream().map(serializerDefinition -> {
                Optional<Object> serializerName;
                String className;
                if (serializerDefinition.contains(";")) {
                    String[] split = serializerDefinition.split(";");
                    if (split.length != 2) {
                        throw new IllegalStateException(String.format("Invalid format for serializer definition [%s] - expected <class>:<serializer-class>", serializerDefinition));
                    }
                    className = split[0];
                    serializerName = Optional.of(split[1]);
                } else {
                    serializerName = Optional.empty();
                    className = serializerDefinition;
                }
                try {
                    Serializer serializer;
                    Class<?> clazz = Class.forName(className);
                    if (serializerName.isPresent()) {
                        Class<?> serializerClazz = Class.forName((String)serializerName.get());
                        serializer = (Serializer)serializerClazz.newInstance();
                    } else {
                        serializer = null;
                    }
                    return Pair.with(clazz, kryo -> serializer);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Class could not be found", ex);
                }
            }).collect(Collectors.toList());
            classList.forEach(c -> builder.addCustom((Class)c.getValue0(), (Function)c.getValue1()));
        }
        this.serializeToString = Boolean.parseBoolean(config.getOrDefault(TOKEN_SERIALIZE_RESULT_TO_STRING, "false").toString());
        this.gryoMapper = builder.create();
    }

    @Override
    public String[] mimeTypesSupported() {
        return new String[]{this.serializeToString ? MIME_TYPE_STRINGD : MIME_TYPE};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResponseMessage deserializeResponse(ByteBuf msg) throws SerializationException {
        try {
            Kryo kryo = this.kryoThreadLocal.get();
            byte[] payload = new byte[msg.readableBytes()];
            msg.readBytes(payload);
            try (Input input = new Input(payload);){
                Map responseData = (Map)kryo.readClassAndObject(input);
                Map status = (Map)responseData.get("status");
                Map result = (Map)responseData.get("result");
                ResponseMessage responseMessage = ResponseMessage.build(UUID.fromString(responseData.get("requestId").toString())).code(ResponseStatusCode.getFromValue((Integer)status.get("code"))).statusMessage(Optional.ofNullable((String)status.get("message")).orElse("")).statusAttributes((Map)status.get("attributes")).result(result.get("data")).responseMetaData((Map)result.get("meta")).create();
                return responseMessage;
            }
        }
        catch (Exception ex) {
            logger.warn("Response [{}] could not be deserialized by {}.", (Object)msg, (Object)GryoMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public ByteBuf serializeResponseAsBinary(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", this.serializeToString ? this.serializeResultToString(responseMessage) : responseMessage.getResult().getData());
            result.put("meta", responseMessage.getResult().getMeta());
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("message", responseMessage.getStatus().getMessage());
            status.put("code", responseMessage.getStatus().getCode().getValue());
            status.put("attributes", responseMessage.getStatus().getAttributes());
            HashMap<String, Serializable> message = new HashMap<String, Serializable>();
            message.put("status", status);
            message.put("result", result);
            message.put("requestId", responseMessage.getRequestId() != null ? responseMessage.getRequestId() : null);
            Kryo kryo = this.kryoThreadLocal.get();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Output output = new Output((OutputStream)baos);
                kryo.writeClassAndObject(output, message);
                long size = output.total();
                if (size > Integer.MAX_VALUE) {
                    throw new SerializationException(String.format("Message size of %s exceeds allocatable space", size));
                }
                encodedMessage = allocator.buffer((int)output.total());
                encodedMessage.writeBytes(output.toBytes());
            }
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn("Response [{}] could not be serialized by {}.", (Object)responseMessage.toString(), (Object)GryoMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RequestMessage deserializeRequest(ByteBuf msg) throws SerializationException {
        try {
            Kryo kryo = this.kryoThreadLocal.get();
            byte[] payload = new byte[msg.readableBytes()];
            msg.readBytes(payload);
            try (Input input = new Input(payload);){
                Map requestData = (Map)kryo.readClassAndObject(input);
                RequestMessage.Builder builder = RequestMessage.build((String)requestData.get("op")).overrideRequestId((UUID)requestData.get("requestId")).processor((String)requestData.get("processor"));
                Map args = (Map)requestData.get("args");
                args.forEach(builder::addArg);
                RequestMessage requestMessage = builder.create();
                return requestMessage;
            }
        }
        catch (Exception ex) {
            logger.warn("Request [{}] could not be deserialized by {}.", (Object)msg, (Object)GryoMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public ByteBuf serializeRequestAsBinary(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            Kryo kryo = this.kryoThreadLocal.get();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Output output = new Output((OutputStream)baos);
                String mimeType = this.serializeToString ? MIME_TYPE_STRINGD : MIME_TYPE;
                output.writeByte(mimeType.length());
                output.write(mimeType.getBytes(UTF8));
                HashMap<String, Object> request = new HashMap<String, Object>();
                request.put("requestId", requestMessage.getRequestId());
                request.put("processor", requestMessage.getProcessor());
                request.put("op", requestMessage.getOp());
                request.put("args", requestMessage.getArgs());
                kryo.writeClassAndObject(output, request);
                long size = output.total();
                if (size > Integer.MAX_VALUE) {
                    throw new SerializationException(String.format("Message size of %s exceeds allocatable space", size));
                }
                encodedMessage = allocator.buffer((int)size);
                encodedMessage.writeBytes(output.toBytes());
            }
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn("Request [{}] could not be serialized by {}.", (Object)requestMessage.toString(), (Object)GryoMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    private Object serializeResultToString(ResponseMessage msg) {
        if (msg.getResult() == null) {
            return "null";
        }
        if (msg.getResult().getData() == null) {
            return "null";
        }
        Object o = msg.getResult().getData();
        if (o instanceof Collection) {
            return ((Collection)o).stream().map(d -> null == d ? "null" : d.toString()).collect(Collectors.toList());
        }
        return o.toString();
    }
}

