/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import groovy.json.JsonBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonMessageSerializerV1d0
implements MessageSerializer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJsonMessageSerializerV1d0.class);
    protected ObjectMapper mapper;
    protected static final String TOKEN_USE_MAPPER_FROM_GRAPH = "useMapperFromGraph";
    protected final TypeReference<Map<String, Object>> mapTypeReference = new TypeReference<Map<String, Object>>(){};

    public AbstractJsonMessageSerializerV1d0() {
        GraphSONMapper.Builder builder = this.configureBuilder(GraphSONMapper.build());
        this.mapper = builder.create().createMapper();
    }

    public AbstractJsonMessageSerializerV1d0(GraphSONMapper mapper) {
        this.mapper = mapper.createMapper();
    }

    abstract byte[] obtainHeader();

    abstract GraphSONMapper.Builder configureBuilder(GraphSONMapper.Builder var1);

    @Override
    public void configure(Map<String, Object> config, Map<String, Graph> graphs) {
        GraphSONMapper.Builder initialBuilder;
        Object graphToUseForMapper = config.get(TOKEN_USE_MAPPER_FROM_GRAPH);
        if (graphToUseForMapper != null) {
            if (null == graphs) {
                throw new IllegalStateException(String.format("No graphs have been provided to the serializer and therefore %s is not a valid configuration", TOKEN_USE_MAPPER_FROM_GRAPH));
            }
            Graph g = graphs.get(graphToUseForMapper.toString());
            if (null == g) {
                throw new IllegalStateException(String.format("There is no graph named [%s] configured to be used in the %s setting", graphToUseForMapper, TOKEN_USE_MAPPER_FROM_GRAPH));
            }
            initialBuilder = g.io().graphSONMapper();
        } else {
            initialBuilder = GraphSONMapper.build();
        }
        this.mapper = this.configureBuilder(initialBuilder).create().createMapper();
    }

    @Override
    public ByteBuf serializeResponseAsBinary(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", responseMessage.getResult().getData());
            result.put("meta", responseMessage.getResult().getMeta());
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("message", responseMessage.getStatus().getMessage());
            status.put("code", responseMessage.getStatus().getCode().getValue());
            status.put("attributes", responseMessage.getStatus().getAttributes());
            HashMap<String, Serializable> message = new HashMap<String, Serializable>();
            message.put("status", status);
            message.put("result", result);
            message.put("requestId", responseMessage.getRequestId() != null ? responseMessage.getRequestId() : null);
            byte[] payload = this.mapper.writeValueAsBytes(message);
            encodedMessage = allocator.buffer(payload.length);
            encodedMessage.writeBytes(payload);
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn("Response [{}] could not be serialized by {}.", (Object)responseMessage.toString(), (Object)AbstractJsonMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public ByteBuf serializeRequestAsBinary(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            byte[] header = this.obtainHeader();
            byte[] payload = this.mapper.writeValueAsBytes((Object)requestMessage);
            encodedMessage = allocator.buffer(header.length + payload.length);
            encodedMessage.writeBytes(header);
            encodedMessage.writeBytes(payload);
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn("Request [{}] could not be serialized by {}.", (Object)requestMessage.toString(), (Object)AbstractJsonMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public RequestMessage deserializeRequest(ByteBuf msg) throws SerializationException {
        try {
            byte[] payload = new byte[msg.readableBytes()];
            msg.readBytes(payload);
            return (RequestMessage)this.mapper.readValue(payload, RequestMessage.class);
        }
        catch (Exception ex) {
            logger.warn("Request [{}] could not be deserialized by {}.", (Object)msg, (Object)AbstractJsonMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public ResponseMessage deserializeResponse(ByteBuf msg) throws SerializationException {
        try {
            byte[] payload = new byte[msg.readableBytes()];
            msg.readBytes(payload);
            Map responseData = (Map)this.mapper.readValue(payload, this.mapTypeReference);
            Map status = (Map)responseData.get("status");
            Map result = (Map)responseData.get("result");
            return ResponseMessage.build(UUID.fromString(responseData.get("requestId").toString())).code(ResponseStatusCode.getFromValue((Integer)status.get("code"))).statusMessage(status.get("message").toString()).statusAttributes((Map)status.get("attributes")).result(result.get("data")).responseMetaData((Map)result.get("meta")).create();
        }
        catch (Exception ex) {
            logger.warn("Response [{}] could not be deserialized by {}.", (Object)msg, (Object)AbstractJsonMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    public static class JsonBuilderJacksonSerializer
    extends StdSerializer<JsonBuilder> {
        public JsonBuilderJacksonSerializer() {
            super(JsonBuilder.class);
        }

        public void serialize(JsonBuilder json, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeRaw(":");
            jsonGenerator.writeRaw(json.toString());
            jsonGenerator.writeRaw(",");
        }
    }

    public static class GremlinServerModule
    extends SimpleModule {
        public GremlinServerModule() {
            super("graphson-gremlin-server");
            this.addSerializer(JsonBuilder.class, (JsonSerializer)new JsonBuilderJacksonSerializer());
        }
    }
}

