/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.driver.ResponseQueue;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;

public class ResultSet
implements Iterable<Result> {
    private final ResponseQueue responseQueue;
    private final ExecutorService executor;
    private final Channel channel;
    private final Supplier<Void> onChannelError;

    public ResultSet(ResponseQueue responseQueue, ExecutorService executor, Channel channel, Supplier<Void> onChannelError) {
        this.executor = executor;
        this.responseQueue = responseQueue;
        this.channel = channel;
        this.onChannelError = onChannelError;
    }

    public boolean allItemsAvailable() {
        return this.responseQueue.getStatus() == ResponseQueue.Status.COMPLETE;
    }

    public int getAvailableItemCount() {
        return this.responseQueue.size();
    }

    public boolean isExhausted() {
        if (!this.responseQueue.isEmpty()) {
            return false;
        }
        this.internalAwaitItems(1);
        assert (!this.responseQueue.isEmpty() || this.allItemsAvailable());
        return this.responseQueue.isEmpty();
    }

    public Result one() {
        ResponseMessage msg = this.responseQueue.poll();
        if (msg != null) {
            return new Result(msg);
        }
        this.internalAwaitItems(1);
        msg = this.responseQueue.poll();
        if (msg != null) {
            return new Result(msg);
        }
        return null;
    }

    public CompletableFuture<Integer> awaitItems(int items) {
        if (this.allItemsAvailable()) {
            CompletableFuture.completedFuture(this.getAvailableItemCount());
        }
        return CompletableFuture.supplyAsync(() -> this.internalAwaitItems(items), this.executor);
    }

    public CompletableFuture<List<Result>> all() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Result> list = new ArrayList<Result>();
            while (!this.isExhausted()) {
                ResponseMessage msg = this.responseQueue.poll();
                if (msg == null) continue;
                list.add(new Result(msg));
            }
            return list;
        }, this.executor);
    }

    public Stream<Result> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1088), false);
    }

    @Override
    public Iterator<Result> iterator() {
        return new Iterator<Result>(){

            @Override
            public boolean hasNext() {
                return !ResultSet.this.isExhausted();
            }

            @Override
            public Result next() {
                return ResultSet.this.one();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private int internalAwaitItems(int items) {
        while (!this.allItemsAvailable() && this.getAvailableItemCount() < items) {
            if (this.channel.isOpen()) continue;
            this.onChannelError.get();
            throw new RuntimeException("Error while processing results from channel - check client and server logs for more information");
        }
        return this.getAvailableItemCount();
    }
}

