/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.tinkerpop.gremlin.driver.ResponseQueue;
import org.apache.tinkerpop.gremlin.driver.exception.ResponseException;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;

class Handler {
    Handler() {
    }

    static class GremlinResponseHandler
    extends SimpleChannelInboundHandler<ResponseMessage> {
        private final ConcurrentMap<UUID, ResponseQueue> pending;

        public GremlinResponseHandler(ConcurrentMap<UUID, ResponseQueue> pending) {
            this.pending = pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void channelRead0(ChannelHandlerContext channelHandlerContext, ResponseMessage response) throws Exception {
            try {
                if (response.getStatus().getCode() == ResponseStatusCode.SUCCESS) {
                    Object data = response.getResult().getData();
                    if (data instanceof List) {
                        List listToUnroll = (List)data;
                        ResponseQueue queue = (ResponseQueue)this.pending.get(response.getRequestId());
                        listToUnroll.forEach(item -> queue.add(ResponseMessage.build(response.getRequestId()).result(item).create()));
                    } else {
                        ((ResponseQueue)this.pending.get(response.getRequestId())).add(response);
                    }
                } else if (response.getStatus().getCode() == ResponseStatusCode.SUCCESS_TERMINATOR) {
                    ((ResponseQueue)this.pending.remove(response.getRequestId())).markComplete();
                } else {
                    ((ResponseQueue)this.pending.get(response.getRequestId())).markError(new ResponseException(response.getStatus().getCode(), response.getStatus().getMessage()));
                }
            }
            finally {
                ReferenceCountUtil.release((Object)response);
            }
        }
    }
}

