/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ConnectionPool;
import org.apache.tinkerpop.gremlin.driver.ResponseQueue;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connection {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private final Channel channel;
    private final URI uri;
    private final ConcurrentMap<UUID, ResponseQueue> pending = new ConcurrentHashMap<UUID, ResponseQueue>();
    private final Cluster cluster;
    private final ConnectionPool pool;
    public static final int MAX_IN_PROCESS = 4;
    public static final int MIN_IN_PROCESS = 1;
    public static final int MAX_WAIT_FOR_CONNECTION = 3000;
    public static final int MAX_CONTENT_LENGTH = 65536;
    public static final int RECONNECT_INITIAL_DELAY = 1000;
    public static final int RECONNECT_INTERVAL = 1000;
    public static final int RESULT_ITERATION_BATCH_SIZE = 64;
    public final AtomicInteger inFlight = new AtomicInteger(0);
    private volatile boolean isDead = false;
    private final int maxInProcess;
    private final AtomicReference<CompletableFuture<Void>> closeFuture = new AtomicReference();

    public Connection(URI uri, ConnectionPool pool, Cluster cluster, int maxInProcess) throws ConnectionException {
        this.uri = uri;
        this.cluster = cluster;
        this.pool = pool;
        this.maxInProcess = maxInProcess;
        Bootstrap b = this.cluster.getFactory().createBootstrap();
        Channelizer.WebSocketChannelizer channelizer = new Channelizer.WebSocketChannelizer();
        channelizer.init(this);
        ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)channelizer);
        try {
            this.channel = b.connect(uri.getHost(), uri.getPort()).sync().channel();
            channelizer.connected();
            logger.info("Created new connection for {}", (Object)uri);
        }
        catch (Exception ie) {
            logger.debug("Error opening connection on {}", (Object)uri);
            throw new ConnectionException(uri, "Could not open connection", ie);
        }
    }

    public int availableInProcess() {
        return this.maxInProcess - this.pending.size();
    }

    public boolean isDead() {
        return this.isDead;
    }

    public boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    URI getUri() {
        return this.uri;
    }

    Cluster getCluster() {
        return this.cluster;
    }

    ConcurrentMap<UUID, ResponseQueue> getPending() {
        return this.pending;
    }

    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (!this.closeFuture.compareAndSet(null, future)) {
            return this.closeFuture.get();
        }
        if (this.pending.isEmpty()) {
            if (null == this.channel) {
                future.complete(null);
            } else {
                this.shutdown(future);
            }
        }
        return future;
    }

    public void close() {
        try {
            this.closeAsync().get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public ChannelPromise write(RequestMessage requestMessage, CompletableFuture<ResultSet> future) {
        Connection thisConnection = this;
        ChannelPromise promise = this.channel.newPromise().addListener(f -> {
            if (!f.isSuccess()) {
                logger.debug(String.format("Write on connection %s failed", thisConnection), f.cause());
                connection.isDead = true;
                thisConnection.returnToPool();
                future.completeExceptionally(f.cause());
            } else {
                LinkedBlockingQueue<ResponseMessage> responseQueue = new LinkedBlockingQueue<ResponseMessage>();
                CompletableFuture<Void> readCompleted = new CompletableFuture<Void>();
                readCompleted.thenAcceptAsync(v -> {
                    thisConnection.returnToPool();
                    if (this.isClosed() && this.pending.isEmpty()) {
                        this.shutdown(this.closeFuture.get());
                    }
                });
                ResponseQueue handler = new ResponseQueue(responseQueue, readCompleted);
                this.pending.put(requestMessage.getRequestId(), handler);
                ResultSet resultSet = new ResultSet(handler, this.cluster.executor(), this.channel, () -> {
                    this.pending.remove(requestMessage.getRequestId());
                    return null;
                });
                future.complete(resultSet);
            }
        });
        this.channel.writeAndFlush((Object)requestMessage, promise);
        return promise;
    }

    public void returnToPool() {
        try {
            if (this.pool != null) {
                this.pool.returnConnection(this);
            }
        }
        catch (ConnectionException ce) {
            logger.debug("Returned {} connection to {} but an error occurred - {}", new Object[]{this, this.pool, ce.getMessage()});
        }
    }

    private void shutdown(CompletableFuture<Void> future) {
        this.channel.writeAndFlush((Object)new CloseWebSocketFrame());
        ChannelPromise promise = this.channel.newPromise();
        promise.addListener(f -> {
            if (f.cause() != null) {
                future.completeExceptionally(f.cause());
            } else {
                future.complete(null);
            }
        });
        this.channel.close(promise);
    }

    public String toString() {
        return String.format("Connection{host=%s, isDead=%s, inFlight=%s, pending=%s}", this.pool.host, this.isDead, this.inFlight, this.pending.size());
    }
}

