/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.javatuples.Pair;

final class ResultQueue {
    private final LinkedBlockingQueue<Result> resultLinkedBlockingQueue;
    private final AtomicReference<Throwable> error = new AtomicReference();
    private final CompletableFuture<Void> readComplete;
    private final Queue<Pair<CompletableFuture<List<Result>>, Integer>> waiting = new ConcurrentLinkedQueue<Pair<CompletableFuture<List<Result>>, Integer>>();
    private final AtomicBoolean flushed = new AtomicBoolean(false);

    public ResultQueue(LinkedBlockingQueue<Result> resultLinkedBlockingQueue, CompletableFuture<Void> readComplete) {
        this.resultLinkedBlockingQueue = resultLinkedBlockingQueue;
        this.readComplete = readComplete;
    }

    public void add(Result result) {
        this.resultLinkedBlockingQueue.offer(result);
        Pair<CompletableFuture<List<Result>>, Integer> nextWaiting = this.waiting.peek();
        if (nextWaiting != null && (this.resultLinkedBlockingQueue.size() >= (Integer)nextWaiting.getValue1() || this.readComplete.isDone())) {
            ResultQueue.internalDrain((Integer)nextWaiting.getValue1(), (CompletableFuture)nextWaiting.getValue0(), this.resultLinkedBlockingQueue);
            this.waiting.remove(nextWaiting);
        }
    }

    public CompletableFuture<List<Result>> await(int items) {
        CompletableFuture<List<Result>> result = new CompletableFuture<List<Result>>();
        if (this.size() >= items || this.readComplete.isDone()) {
            ResultQueue.internalDrain(items, result, this.resultLinkedBlockingQueue);
        } else if (this.flushed.get()) {
            ResultQueue.internalDrain(items, result, this.resultLinkedBlockingQueue);
        } else {
            this.waiting.add((Pair<CompletableFuture<List<Result>>, Integer>)Pair.with(result, (Object)items));
        }
        return result;
    }

    public int size() {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return this.resultLinkedBlockingQueue.size();
    }

    public boolean isEmpty() {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return this.size() == 0;
    }

    public void drainTo(Collection<Result> collection) {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        this.resultLinkedBlockingQueue.drainTo(collection);
    }

    void markComplete() {
        this.readComplete.complete(null);
        this.flushWaiting();
    }

    void markError(Throwable throwable) {
        this.error.set(throwable);
        this.readComplete.complete(null);
        this.flushWaiting();
    }

    private void flushWaiting() {
        while (this.waiting.peek() != null) {
            Pair<CompletableFuture<List<Result>>, Integer> nextWaiting = this.waiting.poll();
            ResultQueue.internalDrain((Integer)nextWaiting.getValue1(), (CompletableFuture)nextWaiting.getValue0(), this.resultLinkedBlockingQueue);
        }
        this.flushed.set(true);
    }

    private static void internalDrain(int items, CompletableFuture<List<Result>> result, LinkedBlockingQueue<Result> resultLinkedBlockingQueue) {
        ArrayList results = new ArrayList(items);
        resultLinkedBlockingQueue.drainTo(results, items);
        result.complete(results);
    }
}

