/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultQueue;
import org.apache.tinkerpop.gremlin.driver.exception.ResponseException;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Handler {
    Handler() {
    }

    static class GremlinResponseHandler
    extends SimpleChannelInboundHandler<ResponseMessage> {
        private static final Logger logger = LoggerFactory.getLogger(GremlinResponseHandler.class);
        private final ConcurrentMap<UUID, ResultQueue> pending;

        public GremlinResponseHandler(ConcurrentMap<UUID, ResultQueue> pending) {
            this.pending = pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void channelRead0(ChannelHandlerContext channelHandlerContext, ResponseMessage response) throws Exception {
            try {
                ResponseStatusCode statusCode = response.getStatus().getCode();
                if (statusCode == ResponseStatusCode.SUCCESS || statusCode == ResponseStatusCode.PARTIAL_CONTENT) {
                    Object data = response.getResult().getData();
                    if (data instanceof List) {
                        List listToUnroll = (List)data;
                        ResultQueue queue = (ResultQueue)this.pending.get(response.getRequestId());
                        listToUnroll.forEach(item -> queue.add(new Result(item)));
                    } else {
                        ((ResultQueue)this.pending.get(response.getRequestId())).add(new Result(response.getResult().getData()));
                    }
                } else if (statusCode != ResponseStatusCode.NO_CONTENT) {
                    ((ResultQueue)this.pending.get(response.getRequestId())).markError(new ResponseException(response.getStatus().getCode(), response.getStatus().getMessage()));
                }
                if (response.getStatus().getCode() != ResponseStatusCode.PARTIAL_CONTENT) {
                    ((ResultQueue)this.pending.remove(response.getRequestId())).markComplete();
                }
            }
            finally {
                ReferenceCountUtil.release((Object)response);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.error("Could not process the response - correct the problem and restart the driver.", cause);
            this.pending.entrySet().stream().forEach(kv -> ((ResultQueue)kv.getValue()).markError(cause));
            ctx.close();
        }
    }
}

