/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.template;

import org.apache.tiles.ArrayStack;
import org.apache.tiles.Attribute;
import org.apache.tiles.Expression;
import org.apache.tiles.ListAttribute;
import org.apache.tiles.template.ComposeStackUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAttributeModel {
    public void start(ArrayStack<Object> composeStack) {
        Attribute attribute = new Attribute();
        composeStack.push((Object)attribute);
    }

    public void end(ArrayStack<Object> composeStack, Object value, String expression, String body, String role, String type) {
        Attribute attribute = (Attribute)composeStack.pop();
        this.addAttributeToList(attribute, composeStack, value, expression, body, role, type);
    }

    public void execute(ArrayStack<Object> composeStack, Object value, String expression, String body, String role, String type) {
        this.addAttributeToList(new Attribute(), composeStack, value, expression, body, role, type);
    }

    private void addAttributeToList(Attribute attribute, ArrayStack<Object> composeStack, Object value, String expression, String body, String role, String type) {
        ListAttribute listAttribute = (ListAttribute)ComposeStackUtil.findAncestorWithClass(composeStack, ListAttribute.class);
        if (listAttribute == null) {
            throw new NullPointerException("There is no ListAttribute in the stack");
        }
        if (value != null) {
            attribute.setValue(value);
        } else if (attribute.getValue() == null && body != null) {
            attribute.setValue((Object)body);
        }
        if (expression != null) {
            attribute.setExpressionObject(Expression.createExpressionFromDescribedExpression((String)expression));
        }
        if (role != null) {
            attribute.setRole(role);
        }
        if (type != null) {
            attribute.setRenderer(type);
        }
        listAttribute.add(attribute);
    }
}

