/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.compat.definition.digester;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.tiles.definition.digester.DigesterDefinitionsReader;

public class CompatibilityDigesterDefinitionsReader
extends DigesterDefinitionsReader {
    protected String[] registrations;

    protected void initSyntax(Digester digester) {
        super.initSyntax(digester);
        this.initDigesterForComponentsDefinitionsSyntax(digester);
        this.initDigesterForInstancesSyntax(digester);
        this.initDigesterForTilesDefinitionsSyntax(digester);
    }

    private void initDigesterForComponentsDefinitionsSyntax(Digester digester) {
        String definitionTag = "component-definitions/definition";
        String putTag = definitionTag + "/put";
        String listTag = definitionTag + "/putList";
        String addListElementTag = listTag + "/add";
        digester.addObjectCreate(definitionTag, DEFINITION_HANDLER_CLASS);
        digester.addSetProperties(definitionTag);
        digester.addSetNext(definitionTag, "addDefinition", DEFINITION_HANDLER_CLASS);
        digester.addObjectCreate(putTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addCallMethod(putTag, "setBody", 0);
        digester.addObjectCreate(listTag, LIST_HANDLER_CLASS);
        digester.addSetProperties(listTag);
        digester.addRule(listTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(addListElementTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(addListElementTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addSetNext(addListElementTag, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addCallMethod(addListElementTag, "setBody", 0);
    }

    private void initDigesterForTilesDefinitionsSyntax(Digester digester) {
        String definitionTag = "tiles-definitions/definition";
        String putTag = definitionTag + "/put";
        String listTag = "putList";
        String definitionListTag = definitionTag + "/" + listTag;
        String addListElementTag = "*/" + listTag + "/add";
        digester.addObjectCreate(putTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addCallMethod(putTag, "setBody", 0);
        digester.addObjectCreate(definitionListTag, LIST_HANDLER_CLASS);
        digester.addSetProperties(definitionListTag);
        digester.addRule(definitionListTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(addListElementTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(addListElementTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addSetNext(addListElementTag, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addCallMethod(addListElementTag, "setBody", 0);
        String nestedList = "*/" + listTag + "/" + listTag;
        digester.addObjectCreate(nestedList, LIST_HANDLER_CLASS);
        digester.addSetProperties(nestedList);
        digester.addSetNext(nestedList, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
    }

    private void initDigesterForInstancesSyntax(Digester digester) {
        String instanceTag = "component-instances/instance";
        String putTag = instanceTag + "/put";
        String putAttributeTag = instanceTag + "/putAttribute";
        String listTag = instanceTag + "/putList";
        String addListElementTag = listTag + "/add";
        digester.addObjectCreate(instanceTag, DEFINITION_HANDLER_CLASS);
        digester.addSetProperties(instanceTag);
        digester.addSetNext(instanceTag, "addDefinition", DEFINITION_HANDLER_CLASS);
        digester.addObjectCreate(putAttributeTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(putTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addSetProperties(putTag);
        digester.addRule(putTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(listTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addSetProperties(listTag);
        digester.addRule(listTag, (Rule)new DigesterDefinitionsReader.PutAttributeRule());
        digester.addObjectCreate(addListElementTag, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(addListElementTag, (Rule)new DigesterDefinitionsReader.FillAttributeRule());
        digester.addSetNext(addListElementTag, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
    }

    protected String[] getRegistrations() {
        if (this.registrations == null) {
            this.registrations = new String[]{"-//Apache Software Foundation//DTD Tiles Configuration 2.0//EN", "/org/apache/tiles/resources/tiles-config_2_0.dtd", "-//Apache Software Foundation//DTD Tiles Configuration 2.1//EN", "/org/apache/tiles/resources/tiles-config_2_1.dtd", "-//Apache Software Foundation//DTD Tiles Configuration 1.1//EN", "/org/apache/tiles/compat/resources/tiles-config_1_1.dtd", "-//Apache Software Foundation//DTD Tiles Configuration 1.3//EN", "/org/apache/tiles/compat/resources/tiles-config_1_3.dtd", "-//Apache Software Foundation//DTD Tiles Configuration 1.4//EN", "/org/apache/tiles/compat/resources/tiles-config_1_4.dtd"};
        }
        return this.registrations;
    }
}

