/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.compat.preparer;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparerSupport;
import org.apache.tiles.servlet.context.ServletTilesRequestContext;

public class UrlPreparer
extends ViewPreparerSupport {
    private String url;

    public UrlPreparer(String url) {
        this.url = url;
    }

    public void execute(TilesRequestContext tilesContext, AttributeContext attributeContext) {
        if (tilesContext instanceof ServletTilesRequestContext) {
            ServletTilesRequestContext servletTilesContext = (ServletTilesRequestContext)tilesContext;
            HttpServletRequest request = servletTilesContext.getRequest();
            HttpServletResponse response = servletTilesContext.getResponse();
            ServletContext servletContext = (ServletContext)servletTilesContext.getContext();
            RequestDispatcher rd = servletContext.getRequestDispatcher(this.url);
            if (rd == null) {
                throw new PreparerException("Controller can't find url '" + this.url + "'.");
            }
            try {
                rd.include((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
                throw new PreparerException("The request dispatcher threw an exception", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new PreparerException("The request dispatcher threw an I/O exception", (Exception)e);
            }
        } else {
            throw new PreparerException("Cannot dispatch url '" + this.url + "' since this preparer has not been called under a servlet environment");
        }
    }
}

