/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.access;

import java.lang.reflect.Method;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.reflect.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TilesAccess {
    public static final String CONTAINER_ATTRIBUTE = "org.apache.tiles.CONTAINER";
    private static final String CONTEXT_ATTRIBUTE = "org.apache.tiles.APPLICATION_CONTEXT";

    private TilesAccess() {
    }

    @Deprecated
    public static TilesContainer getContainer(Object context) {
        return (TilesContainer)TilesAccess.getAttribute(context, CONTAINER_ATTRIBUTE);
    }

    public static void setContainer(TilesApplicationContext context, TilesContainer container) {
        TilesAccess.setContainer(context, container, CONTAINER_ATTRIBUTE);
    }

    public static void setContainer(TilesApplicationContext context, TilesContainer container, String key) {
        Logger log = LoggerFactory.getLogger(TilesAccess.class);
        if (key == null) {
            key = CONTAINER_ATTRIBUTE;
        }
        if (container == null) {
            if (log.isInfoEnabled()) {
                log.info("Removing TilesContext for context: " + context.getClass().getName());
            }
            context.getApplicationScope().remove(key);
        } else {
            if (log.isInfoEnabled()) {
                log.info("Publishing TilesContext for context: " + context.getClass().getName());
            }
            context.getApplicationScope().put(key, container);
        }
    }

    @Deprecated
    public static void setContainer(Object context, TilesContainer container) {
        Logger log = LoggerFactory.getLogger(TilesAccess.class);
        if (container == null) {
            if (log.isInfoEnabled()) {
                log.info("Removing TilesContext for context: " + context.getClass().getName());
            }
            TilesAccess.removeAttribute(context, CONTAINER_ATTRIBUTE);
        }
        if (container != null && log.isInfoEnabled()) {
            log.info("Publishing TilesContext for context: " + context.getClass().getName());
        }
        TilesAccess.setAttribute(context, CONTAINER_ATTRIBUTE, container);
    }

    @Deprecated
    public static TilesApplicationContext getApplicationContext(Object context) {
        TilesContainer container = TilesAccess.getContainer(context);
        if (container != null) {
            return container.getApplicationContext();
        }
        return (TilesApplicationContext)TilesAccess.getAttribute(context, CONTEXT_ATTRIBUTE);
    }

    private static Object getAttribute(Object context, String attributeName) {
        Class<?> contextClass = context.getClass();
        Method attrMethod = ClassUtil.getForcedAccessibleMethod(contextClass, "getAttribute", String.class);
        return ClassUtil.invokeMethod(context, attrMethod, attributeName);
    }

    private static void setAttribute(Object context, String name, Object value) {
        Class<?> contextClass = context.getClass();
        Method attrMethod = ClassUtil.getForcedAccessibleMethod(contextClass, "setAttribute", String.class, Object.class);
        ClassUtil.invokeMethod(context, attrMethod, name, value);
    }

    private static void removeAttribute(Object context, String name) {
        Class<?> contextClass = context.getClass();
        Method attrMethod = ClassUtil.getForcedAccessibleMethod(contextClass, "removeAttribute", String.class);
        ClassUtil.invokeMethod(context, attrMethod, name);
    }
}

