/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.client;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.tika.client.HttpClientFactory;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.serialization.JsonFetchEmitTuple;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.server.client.TikaEmitterResult;
import org.apache.tika.server.client.TikaPipesHttpClient;

public class TikaClient {
    private final Random random = new Random();
    private final List<TikaPipesHttpClient> clients;

    private TikaClient(List<TikaPipesHttpClient> clients) {
        this.clients = clients;
    }

    public static TikaClient get(HttpClientFactory httpClientFactory, List<String> tikaServers) throws TikaConfigException {
        ArrayList<TikaPipesHttpClient> clients = new ArrayList<TikaPipesHttpClient>();
        for (String url : tikaServers) {
            clients.add(new TikaPipesHttpClient(url, httpClientFactory.copy()));
        }
        return new TikaClient(clients);
    }

    public TikaEmitterResult parse(FetchEmitTuple fetchEmit) throws IOException, TikaException {
        TikaPipesHttpClient client = this.getHttpClient();
        StringWriter writer = new StringWriter();
        JsonFetchEmitTuple.toJson(fetchEmit, writer);
        return client.postJson(writer.toString());
    }

    private TikaPipesHttpClient getHttpClient() {
        if (this.clients.size() == 1) {
            return this.clients.get(0);
        }
        int index = this.random.nextInt(this.clients.size());
        return this.clients.get(index);
    }
}

