/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.serialization;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.serialization.TikaJsonDeserializer;
import org.apache.tika.serialization.TikaJsonSerializer;

public class ParseContextDeserializer
extends JsonDeserializer<ParseContext> {
    public ParseContext deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        JsonNode root = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        return ParseContextDeserializer.readParseContext(root);
    }

    public static ParseContext readParseContext(JsonNode jsonNode) throws IOException {
        JsonNode contextNode = jsonNode.get("parseContext");
        if (contextNode == null) {
            contextNode = jsonNode;
        }
        ParseContext parseContext = new ParseContext();
        Iterator it = contextNode.fields();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            String superClassName = (String)e.getKey();
            JsonNode obj = (JsonNode)e.getValue();
            String className = ParseContextDeserializer.readVal(TikaJsonSerializer.INSTANTIATED_CLASS_KEY, obj, null, true);
            try {
                Class<?> clazz = Class.forName(className);
                Class<?> superClazz = className.equals(superClassName) ? clazz : Class.forName(superClassName);
                parseContext.set(superClazz, TikaJsonDeserializer.deserialize(clazz, obj));
            }
            catch (ReflectiveOperationException ex) {
                throw new IOException(ex);
            }
        }
        return parseContext;
    }

    private static String readVal(String key, JsonNode jsonObj, String defaultRet, boolean isRequired) throws IOException {
        JsonNode valNode = jsonObj.get(key);
        if (valNode == null) {
            if (isRequired) {
                throw new IOException("required value string, but see: " + key);
            }
            return defaultRet;
        }
        return valNode.asText();
    }
}

