/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.io.Writer;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadataBase;

public class JsonMetadata
extends JsonMetadataBase {
    private static Gson GSON = JsonMetadata.defaultInit();

    public static void toJson(Metadata metadata, Writer writer) throws TikaException {
        try {
            GSON.toJson((Object)metadata, (Appendable)writer);
        }
        catch (JsonIOException e) {
            throw new TikaException(e.getMessage());
        }
    }

    public static Metadata fromJson(Reader reader) throws TikaException {
        Metadata m = null;
        try {
            m = (Metadata)GSON.fromJson(reader, Metadata.class);
        }
        catch (JsonParseException e) {
            throw new TikaException(e.getMessage());
        }
        return m;
    }

    public static void setGson(Gson gson) {
        GSON = gson;
    }

    public static void setPrettyPrinting(boolean prettyPrint) {
        GSON = prettyPrint ? JsonMetadata.prettyInit() : JsonMetadata.defaultInit();
    }
}

