/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLErrorLogger
implements ErrorHandler,
ErrorListener,
XMLReporter {
    private final Logger log;

    public XMLErrorLogger(Logger log) {
        this.log = log;
    }

    @Override
    public void warning(SAXParseException e) {
        this.log.warn("XML parse warning in '{}', line {}, column {}:", e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void warning(TransformerException e) {
        this.log.warn(e.getMessageAndLocation());
    }

    @Override
    public void error(TransformerException e) throws TransformerException {
        throw e;
    }

    @Override
    public void fatalError(TransformerException e) throws TransformerException {
        throw e;
    }

    @Override
    public void report(String message, String errorType, Object relatedInformation, Location loc) {
        StringBuilder sb = new StringBuilder("XML parser reported ").append(errorType);
        if (loc != null) {
            sb.append(" in \"").append(loc.getSystemId()).append("\", line ").append(loc.getLineNumber()).append(", column ").append(loc.getColumnNumber());
        }
        this.log.warn("{}", (Object)sb.append(": ").append(message));
    }
}

