/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.V2Response;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.Utils;

public class V2Request
extends SolrRequest<V2Response>
implements MapWriter {
    public static final ThreadLocal<AtomicLong> v2Calls = new ThreadLocal();
    static final Pattern COLL_REQ_PATTERN = Pattern.compile("/(c|collections)/([^/])+/(?!shards)");
    private Object payload;
    private SolrParams solrParams;
    public final boolean useBinary;
    private String collection;
    private String mimeType;
    private boolean forceV2 = false;
    private boolean isPerCollectionRequest = false;
    private ResponseParser parser;

    private V2Request(SolrRequest.METHOD m, String resource, boolean useBinary) {
        super(m, resource);
        Matcher matcher = COLL_REQ_PATTERN.matcher(this.getPath());
        if (matcher.find()) {
            this.collection = matcher.group(2);
            this.isPerCollectionRequest = true;
        }
        this.useBinary = useBinary;
    }

    public boolean isForceV2() {
        return this.forceV2;
    }

    @Override
    public SolrParams getParams() {
        return this.solrParams;
    }

    @Override
    public RequestWriter.ContentWriter getContentWriter(String s) {
        if (v2Calls.get() != null) {
            v2Calls.get().incrementAndGet();
        }
        if (this.payload == null) {
            return null;
        }
        if (this.payload instanceof String) {
            return new RequestWriter.StringPayloadContentWriter((String)this.payload, "application/json");
        }
        return new RequestWriter.ContentWriter(){

            @Override
            public void write(OutputStream os) throws IOException {
                if (V2Request.this.payload instanceof ByteBuffer) {
                    ByteBuffer b = (ByteBuffer)V2Request.this.payload;
                    os.write(b.array(), b.arrayOffset(), b.limit());
                    return;
                }
                if (V2Request.this.payload instanceof InputStream) {
                    IOUtils.copy((InputStream)V2Request.this.payload, os);
                    return;
                }
                if (V2Request.this.useBinary) {
                    new JavaBinCodec().marshal(V2Request.this.payload, os);
                } else {
                    Utils.writeJson(V2Request.this.payload, os, false);
                }
            }

            @Override
            public String getContentType() {
                if (V2Request.this.mimeType != null) {
                    return V2Request.this.mimeType;
                }
                return V2Request.this.useBinary ? "application/javabin" : "application/json";
            }
        };
    }

    public boolean isPerCollectionRequest() {
        return this.isPerCollectionRequest;
    }

    @Override
    public String getCollection() {
        return this.collection;
    }

    @Override
    protected V2Response createResponse(SolrClient client) {
        return new V2Response();
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)"method", this.getMethod().toString());
        ew.put((CharSequence)"path", this.getPath());
        ew.putIfNotNull("params", this.solrParams);
        ew.putIfNotNull("command", this.payload);
    }

    @Override
    public ResponseParser getResponseParser() {
        if (this.parser != null) {
            return this.parser;
        }
        return super.getResponseParser();
    }

    public static class Builder {
        private String resource;
        private SolrRequest.METHOD method = SolrRequest.METHOD.GET;
        private Object payload;
        private SolrParams params;
        private boolean useBinary = false;
        private boolean forceV2EndPoint = false;
        private ResponseParser parser;
        private String mimeType;

        public Builder(String resource) {
            if (!resource.startsWith("/")) {
                resource = "/" + resource;
            }
            this.resource = resource;
        }

        public Builder withMethod(SolrRequest.METHOD m) {
            this.method = m;
            return this;
        }

        public Builder forceV2(boolean flag) {
            this.forceV2EndPoint = flag;
            return this;
        }

        public Builder withPayload(String payload) {
            if (payload != null) {
                this.payload = payload;
            }
            return this;
        }

        public Builder withPayload(Object payload) {
            this.payload = payload;
            return this;
        }

        public Builder withParams(SolrParams params) {
            this.params = params;
            return this;
        }

        public Builder useBinary(boolean flag) {
            this.useBinary = flag;
            return this;
        }

        public Builder withResponseParser(ResponseParser parser) {
            this.parser = parser;
            return this;
        }

        public Builder withMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public V2Request build() {
            V2Request v2Request = new V2Request(this.method, this.resource, this.useBinary);
            v2Request.solrParams = this.params;
            v2Request.payload = this.payload;
            v2Request.forceV2 = this.forceV2EndPoint;
            v2Request.mimeType = this.mimeType;
            v2Request.parser = this.parser;
            return v2Request;
        }
    }
}

