/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.math3.geometry.enclosing.EnclosingBall;
import org.apache.commons.math3.geometry.enclosing.WelzlEncloser;
import org.apache.commons.math3.geometry.euclidean.twod.DiskGenerator;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class EnclosingDiskEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public EnclosingDiskEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... objects) throws IOException {
        if (objects[0] instanceof Matrix) {
            return EnclosingDiskEvaluator.getEnclosingDisk((Matrix)objects[0]);
        }
        throw new IOException("The enclosingDisk function operates on a matrix of 2D vectors");
    }

    public static EnclosingBall getEnclosingDisk(Matrix matrix) throws IOException {
        double[][] data = matrix.getData();
        ArrayList<Vector2D> points = new ArrayList<Vector2D>(data.length);
        if (data[0].length == 2) {
            for (double[] row : data) {
                points.add(new Vector2D(row[0], row[1]));
            }
            WelzlEncloser<Euclidean2D, Vector2D> welzlEncloser = new WelzlEncloser<Euclidean2D, Vector2D>(0.001, new DiskGenerator());
            EnclosingBall<Euclidean2D, Vector2D> enclosingBall = welzlEncloser.enclose(points);
            return enclosingBall;
        }
        throw new IOException("The enclosingDisk function operates on a matrix of 2D vectors");
    }
}

