/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MetricDescriptorName
implements ResourceName {
    private static final PathTemplate PROJECT_METRIC_DESCRIPTOR = PathTemplate.createWithoutUrlEncoding("projects/{project}/metricDescriptors/{metric_descriptor=**}");
    private static final PathTemplate ORGANIZATION_METRIC_DESCRIPTOR = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/metricDescriptors/{metric_descriptor=**}");
    private static final PathTemplate FOLDER_METRIC_DESCRIPTOR = PathTemplate.createWithoutUrlEncoding("folders/{folder}/metricDescriptors/{metric_descriptor=**}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String metricDescriptor;
    private final String organization;
    private final String folder;

    @Deprecated
    protected MetricDescriptorName() {
        this.project = null;
        this.metricDescriptor = null;
        this.organization = null;
        this.folder = null;
    }

    private MetricDescriptorName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.metricDescriptor = Preconditions.checkNotNull(builder.getMetricDescriptor());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_METRIC_DESCRIPTOR;
    }

    private MetricDescriptorName(OrganizationMetricDescriptorBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.metricDescriptor = Preconditions.checkNotNull(builder.getMetricDescriptor());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_METRIC_DESCRIPTOR;
    }

    private MetricDescriptorName(FolderMetricDescriptorBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.metricDescriptor = Preconditions.checkNotNull(builder.getMetricDescriptor());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_METRIC_DESCRIPTOR;
    }

    public String getProject() {
        return this.project;
    }

    public String getMetricDescriptor() {
        return this.metricDescriptor;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectMetricDescriptorBuilder() {
        return new Builder();
    }

    public static OrganizationMetricDescriptorBuilder newOrganizationMetricDescriptorBuilder() {
        return new OrganizationMetricDescriptorBuilder();
    }

    public static FolderMetricDescriptorBuilder newFolderMetricDescriptorBuilder() {
        return new FolderMetricDescriptorBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MetricDescriptorName of(String project, String metricDescriptor) {
        return MetricDescriptorName.newBuilder().setProject(project).setMetricDescriptor(metricDescriptor).build();
    }

    public static MetricDescriptorName ofProjectMetricDescriptorName(String project, String metricDescriptor) {
        return MetricDescriptorName.newBuilder().setProject(project).setMetricDescriptor(metricDescriptor).build();
    }

    public static MetricDescriptorName ofOrganizationMetricDescriptorName(String organization, String metricDescriptor) {
        return MetricDescriptorName.newOrganizationMetricDescriptorBuilder().setOrganization(organization).setMetricDescriptor(metricDescriptor).build();
    }

    public static MetricDescriptorName ofFolderMetricDescriptorName(String folder, String metricDescriptor) {
        return MetricDescriptorName.newFolderMetricDescriptorBuilder().setFolder(folder).setMetricDescriptor(metricDescriptor).build();
    }

    public static String format(String project, String metricDescriptor) {
        return MetricDescriptorName.newBuilder().setProject(project).setMetricDescriptor(metricDescriptor).build().toString();
    }

    public static String formatProjectMetricDescriptorName(String project, String metricDescriptor) {
        return MetricDescriptorName.newBuilder().setProject(project).setMetricDescriptor(metricDescriptor).build().toString();
    }

    public static String formatOrganizationMetricDescriptorName(String organization, String metricDescriptor) {
        return MetricDescriptorName.newOrganizationMetricDescriptorBuilder().setOrganization(organization).setMetricDescriptor(metricDescriptor).build().toString();
    }

    public static String formatFolderMetricDescriptorName(String folder, String metricDescriptor) {
        return MetricDescriptorName.newFolderMetricDescriptorBuilder().setFolder(folder).setMetricDescriptor(metricDescriptor).build().toString();
    }

    public static MetricDescriptorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_METRIC_DESCRIPTOR.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_METRIC_DESCRIPTOR.match(formattedString);
            return MetricDescriptorName.ofProjectMetricDescriptorName(matchMap.get("project"), matchMap.get("metric_descriptor"));
        }
        if (ORGANIZATION_METRIC_DESCRIPTOR.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_METRIC_DESCRIPTOR.match(formattedString);
            return MetricDescriptorName.ofOrganizationMetricDescriptorName(matchMap.get("organization"), matchMap.get("metric_descriptor"));
        }
        if (FOLDER_METRIC_DESCRIPTOR.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_METRIC_DESCRIPTOR.match(formattedString);
            return MetricDescriptorName.ofFolderMetricDescriptorName(matchMap.get("folder"), matchMap.get("metric_descriptor"));
        }
        throw new ValidationException("MetricDescriptorName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<MetricDescriptorName> parseList(List<String> formattedStrings) {
        ArrayList<MetricDescriptorName> list = new ArrayList<MetricDescriptorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MetricDescriptorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MetricDescriptorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MetricDescriptorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_METRIC_DESCRIPTOR.matches(formattedString) || ORGANIZATION_METRIC_DESCRIPTOR.matches(formattedString) || FOLDER_METRIC_DESCRIPTOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MetricDescriptorName metricDescriptorName = this;
            synchronized (metricDescriptorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.metricDescriptor != null) {
                        fieldMapBuilder.put("metric_descriptor", this.metricDescriptor);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MetricDescriptorName that = (MetricDescriptorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.metricDescriptor, that.metricDescriptor) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.fixedValue);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.metricDescriptor);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.organization);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.folder);
    }

    public static class FolderMetricDescriptorBuilder {
        private String folder;
        private String metricDescriptor;

        protected FolderMetricDescriptorBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getMetricDescriptor() {
            return this.metricDescriptor;
        }

        public FolderMetricDescriptorBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderMetricDescriptorBuilder setMetricDescriptor(String metricDescriptor) {
            this.metricDescriptor = metricDescriptor;
            return this;
        }

        public MetricDescriptorName build() {
            return new MetricDescriptorName(this);
        }
    }

    public static class OrganizationMetricDescriptorBuilder {
        private String organization;
        private String metricDescriptor;

        protected OrganizationMetricDescriptorBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getMetricDescriptor() {
            return this.metricDescriptor;
        }

        public OrganizationMetricDescriptorBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationMetricDescriptorBuilder setMetricDescriptor(String metricDescriptor) {
            this.metricDescriptor = metricDescriptor;
            return this;
        }

        public MetricDescriptorName build() {
            return new MetricDescriptorName(this);
        }
    }

    public static class Builder {
        private String project;
        private String metricDescriptor;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getMetricDescriptor() {
            return this.metricDescriptor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setMetricDescriptor(String metricDescriptor) {
            this.metricDescriptor = metricDescriptor;
            return this;
        }

        private Builder(MetricDescriptorName metricDescriptorName) {
            Preconditions.checkArgument(Objects.equals(metricDescriptorName.pathTemplate, PROJECT_METRIC_DESCRIPTOR), "toBuilder is only supported when MetricDescriptorName has the pattern of projects/{project}/metricDescriptors/{metric_descriptor=**}");
            this.project = metricDescriptorName.project;
            this.metricDescriptor = metricDescriptorName.metricDescriptor;
        }

        public MetricDescriptorName build() {
            return new MetricDescriptorName(this);
        }
    }
}

