/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.sqlite3;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.jdbc.AbstractDBParser;
import org.apache.tika.parser.jdbc.JDBCTableReader;
import org.apache.tika.parser.sqlite3.SQLite3TableReader;
import org.sqlite.SQLiteConfig;

class SQLite3DBParser
extends AbstractDBParser {
    protected static final String SQLITE_CLASS_NAME = "org.sqlite.JDBC";
    Path tmpFile = null;

    SQLite3DBParser() {
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return null;
    }

    protected Connection getConnection(InputStream stream, Metadata metadata, ParseContext context) throws IOException {
        String connectionString = this.getConnectionString(stream, metadata, context);
        Connection connection = null;
        try {
            Class.forName(this.getJDBCClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        try {
            SQLiteConfig config = new SQLiteConfig();
            config.setReadOnly(true);
            connection = config.createConnection(connectionString);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        return connection;
    }

    protected String getConnectionString(InputStream is, Metadata metadata, ParseContext context) throws IOException {
        TikaInputStream tis = TikaInputStream.cast((InputStream)is);
        if (tis != null) {
            Path dbFile = tis.getPath();
            return "jdbc:sqlite:" + dbFile.toAbsolutePath().toString();
        }
        this.tmpFile = Files.createTempFile("tika-sqlite-tmp", "", new FileAttribute[0]);
        Files.copy(is, this.tmpFile, StandardCopyOption.REPLACE_EXISTING);
        return "jdbc:sqlite:" + this.tmpFile.toAbsolutePath().toString();
    }

    public void close() throws SQLException, IOException {
        try {
            super.close();
        }
        finally {
            if (this.tmpFile != null) {
                Files.delete(this.tmpFile);
            }
        }
    }

    protected String getJDBCClassName() {
        return SQLITE_CLASS_NAME;
    }

    protected List<String> getTableNames(Connection connection, Metadata metadata, ParseContext context) throws SQLException {
        LinkedList<String> tableNames = new LinkedList<String>();
        try (Statement st = connection.createStatement();){
            String sql = "SELECT name FROM sqlite_master WHERE type='table'";
            try (ResultSet rs = st.executeQuery(sql);){
                while (rs.next()) {
                    tableNames.add(rs.getString(1));
                }
            }
        }
        return tableNames;
    }

    public JDBCTableReader getTableReader(Connection connection, String tableName, ParseContext context) {
        return new SQLite3TableReader(connection, tableName, new EmbeddedDocumentUtil(context));
    }

    protected JDBCTableReader getTableReader(Connection connection, String tableName, EmbeddedDocumentUtil embeddedDocumentUtil) {
        return new SQLite3TableReader(connection, tableName, embeddedDocumentUtil);
    }
}

