/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.referencing.operation.builder.LocalizationGridException;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.util.AxisDirections;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.base.Axis;
import org.apache.sis.storage.netcdf.base.CRSBuilder;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.GridCacheValue;
import org.apache.sis.storage.netcdf.base.NamedElement;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Exceptions;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class Grid
extends NamedElement {
    public static final int MIN_DIMENSION = 2;
    static final int MIN_SPAN = 2;
    private Axis[] axes;
    private CoordinateReferenceSystem crs;
    private boolean isCRSDetermined;
    private GridGeometry geometry;
    private boolean isGeometryDetermined;
    private PixelInCell anchor = PixelInCell.CELL_CENTER;

    protected Grid() {
    }

    protected abstract Grid forDimensions(Dimension[] var1);

    public abstract int getSourceDimensions();

    protected abstract List<Dimension> getDimensions();

    public final Axis[] getAxes(Decoder decoder) throws IOException, DataStoreException {
        if (this.axes == null) {
            Axis axis;
            this.axes = this.createAxes(decoder);
            Axis[] workspace = new Axis[this.axes.length];
            int i = 0;
            int deferred = workspace.length;
            Axis[] axisArray = this.axes;
            int n = axisArray.length;
            for (int j = 0; j < n; ++j) {
                Axis axis2;
                workspace[(axis2 = axisArray[j]).getNumDimensions() <= 1 ? i++ : --deferred] = axis2;
            }
            deferred = workspace.length;
            while (i < workspace.length) {
                axis = workspace[i];
                if (i < deferred && axis.isWraparound()) {
                    System.arraycopy(workspace, i + 1, workspace, i, --deferred - i);
                    workspace[deferred] = axis;
                    continue;
                }
                axis.mainDimensionFirst(workspace, i);
                ++i;
            }
            for (i = 0; i < this.axes.length; ++i) {
                axis = this.axes[i];
                if (axis.getNumDimensions() != 0) continue;
                int p = i;
                for (int j = 0; j < this.axes.length; ++j) {
                    if (axis.direction.compareTo(this.axes[j].direction) <= 0) continue;
                    p = j + 1;
                }
                if (p == i) continue;
                if (p > i) {
                    --p;
                }
                System.arraycopy(this.axes, i + 1, this.axes, i, this.axes.length - (i + 1));
                System.arraycopy(this.axes, p, this.axes, p + 1, this.axes.length - (p + 1));
                this.axes[p] = axis;
                break;
            }
        }
        return this.axes;
    }

    protected abstract Axis[] createAxes(Decoder var1) throws IOException, DataStoreException;

    protected abstract boolean containsAllNamedAxes(String[] var1);

    final CoordinateReferenceSystem getCoordinateReferenceSystem(Decoder decoder, List<Exception> warnings, List<GridCacheValue> linearizations, Matrix reorderGridToCRS) throws IOException, DataStoreException {
        boolean useCache;
        boolean bl = useCache = linearizations == null || linearizations.isEmpty();
        if (useCache & this.isCRSDetermined) {
            return this.crs;
        }
        try {
            if (useCache) {
                this.isCRSDetermined = true;
            }
            CoordinateReferenceSystem result = CRSBuilder.assemble(decoder, this, linearizations, reorderGridToCRS);
            if (useCache) {
                this.crs = result;
            }
            return result;
        }
        catch (NullPointerException | FactoryException ex) {
            if (Grid.isNewWarning(ex, warnings)) {
                this.canNotCreate(decoder, "getCoordinateReferenceSystem", (short)11, ex);
            }
            return null;
        }
    }

    private static boolean isNewWarning(Exception ex, List<Exception> warnings) {
        if (warnings != null) {
            for (Exception previous : warnings) {
                if (!Exceptions.messageEquals(ex, previous)) continue;
                return false;
            }
            warnings.add(ex);
        }
        return true;
    }

    private GridExtent getExtent(Axis[] axes) {
        List<Dimension> dimensions = this.getDimensions();
        int n = dimensions.size();
        long[] high = new long[n];
        for (int i = 0; i < n; ++i) {
            long length = dimensions.get(i).length();
            if (length <= 0L) {
                return null;
            }
            high[n - 1 - i] = length;
        }
        DimensionNameType[] names = new DimensionNameType[n];
        switch (n) {
            default: {
                names[1] = DimensionNameType.ROW;
            }
            case 1: {
                names[0] = DimensionNameType.COLUMN;
            }
            case 0: 
        }
        for (Axis axis : axes) {
            DimensionNameType name;
            if (axis.getNumDimensions() != 1) continue;
            if (AxisDirections.isVertical(axis.direction)) {
                name = DimensionNameType.VERTICAL;
            } else {
                if (!AxisDirections.isTemporal(axis.direction)) continue;
                name = DimensionNameType.TIME;
            }
            int dim = axis.gridDimensionIndices[0];
            dim = names.length - 1 - dim;
            if (dim < 0) continue;
            names[dim] = name;
        }
        return new GridExtent(names, null, high, false);
    }

    final GridGeometry getGridGeometry(Decoder decoder) throws IOException, DataStoreException {
        if (!this.isGeometryDetermined) {
            try {
                this.isGeometryDetermined = true;
                Axis[] axes = this.getAxes(decoder);
                int lastSrcDim = this.getSourceDimensions();
                int lastTgtDim = axes.length;
                int[] deferred = new int[axes.length];
                ArrayList<MathTransform> nonLinears = new ArrayList<MathTransform>(axes.length);
                MatrixSIS affine = Matrices.createZero(lastTgtDim + 1, lastSrcDim + 1);
                affine.setElement(lastTgtDim--, lastSrcDim--, 1.0);
                for (int tgtDim = 0; tgtDim < axes.length; ++tgtDim) {
                    if (axes[tgtDim].trySetTransform(affine, lastSrcDim, tgtDim, nonLinears)) continue;
                    deferred[nonLinears.size() - 1] = tgtDim;
                }
                int[] gridDimensionIndices = new int[nonLinears.size()];
                Arrays.fill(gridDimensionIndices, -1);
                block7: for (int i = 0; i < gridDimensionIndices.length; ++i) {
                    int tgtDim = deferred[i];
                    Axis axis = axes[tgtDim];
                    block8: for (int srcDim : axis.gridDimensionIndices) {
                        srcDim = lastSrcDim - srcDim;
                        int j = affine.getNumRow();
                        while (--j >= 0) {
                            if (affine.getElement(j, srcDim) == 0.0) continue;
                            continue block8;
                        }
                        gridDimensionIndices[i] = srcDim;
                        affine.setElement(tgtDim, srcDim, 1.0);
                        continue block7;
                    }
                }
                ArrayList<GridCacheValue> linearizations = new ArrayList<GridCacheValue>();
                block10: for (int i = 0; i < nonLinears.size(); ++i) {
                    if (nonLinears.get(i) != null) continue;
                    int j = i;
                    block11: while (++j < nonLinears.size()) {
                        GridCacheValue grid;
                        if (nonLinears.get(j) != null) continue;
                        Object[] gridAxes = new Axis[]{axes[deferred[i]], axes[deferred[j]]};
                        int srcDim = gridDimensionIndices[i];
                        int otherDim = gridDimensionIndices[j];
                        switch (srcDim - otherDim) {
                            case -1: {
                                break;
                            }
                            case 1: {
                                ArraysExt.swap(gridAxes, 0, 1);
                                break;
                            }
                            default: {
                                continue block11;
                            }
                        }
                        if ((grid = gridAxes[0].createLocalizationGrid((Axis)gridAxes[1])) == null) continue;
                        nonLinears.set(i, grid.gridToCRS);
                        nonLinears.remove(j);
                        int n = nonLinears.size() - j;
                        System.arraycopy(deferred, j + 1, deferred, j, n);
                        System.arraycopy(gridDimensionIndices, j + 1, gridDimensionIndices, j, n);
                        if (otherDim < srcDim) {
                            gridDimensionIndices[i] = otherDim;
                        }
                        if (grid.linearizationTarget == null) continue block10;
                        linearizations.add(grid);
                        continue block10;
                    }
                }
                for (int s : gridDimensionIndices) {
                    if (s >= 0) continue;
                    return null;
                }
                CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem(decoder, null, linearizations, affine);
                MathTransform gridToCRS = null;
                int nonLinearCount = nonLinears.size();
                MathTransformFactory factory = decoder.getMathTransformFactory();
                nonLinears.add(factory.createAffineTransform(affine));
                for (int i = 0; i <= nonLinearCount; ++i) {
                    MathTransform tr = (MathTransform)nonLinears.get(i);
                    if (tr == null) continue;
                    if (i < nonLinearCount) {
                        int srcDim = gridDimensionIndices[i];
                        tr = factory.createPassThroughTransform(srcDim, tr, lastSrcDim + 1 - (srcDim + tr.getSourceDimensions()));
                    }
                    gridToCRS = gridToCRS == null ? tr : factory.createConcatenatedTransform(gridToCRS, tr);
                }
                for (Axis axis : axes) {
                    if (!axis.isCellCorner()) continue;
                    this.anchor = PixelInCell.CELL_CORNER;
                    break;
                }
                this.geometry = new GridGeometry(this.getExtent(axes), this.anchor, gridToCRS, crs);
            }
            catch (IllegalGridGeometryException | TransformException | FactoryException ex) {
                this.canNotCreate(decoder, "getGridGeometry", (short)12, ex);
            }
        }
        return this.geometry;
    }

    final PixelInCell getAnchor() {
        return this.anchor;
    }

    private void canNotCreate(Decoder decoder, String caller, short key, Exception ex) {
        CharSequence message = null;
        if (ex instanceof LocalizationGridException) {
            message = ((LocalizationGridException)ex).getPotentialCause();
        }
        if (message == null) {
            message = ex.getLocalizedMessage();
        }
        Grid.warning(decoder.listeners, Grid.class, caller, ex, null, key, decoder.getFilename(), this.getName(), message);
    }
}

