/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.referencing.util.ReferencingFactoryContainer;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.netcdf.base.Convention;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.DiscreteSampling;
import org.apache.sis.storage.netcdf.base.FeatureSet;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.base.GridCacheKey;
import org.apache.sis.storage.netcdf.base.GridCacheValue;
import org.apache.sis.storage.netcdf.base.GridMapping;
import org.apache.sis.storage.netcdf.base.HYCOM;
import org.apache.sis.storage.netcdf.base.Node;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.storage.netcdf.internal.Resources;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.PerformanceLevel;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.NameSpace;

public abstract class Decoder
extends ReferencingFactoryContainer {
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.netcdf");
    public static final String FORMAT_NAME = "netCDF";
    public Path location;
    private Convention convention;
    public NameSpace namespace;
    public final DefaultNameFactory nameFactory;
    public final GeometryLibrary geomlib;
    final Datum[] datumCache;
    final Map<Object, GridMapping> gridMapping;
    final Map<GridCacheKey, GridCacheValue> localizationGrids;
    public final StoreListeners listeners;
    public volatile boolean canceled;

    protected Decoder(GeometryLibrary geomlib, StoreListeners listeners) {
        Objects.requireNonNull(listeners);
        this.geomlib = geomlib;
        this.listeners = listeners;
        this.nameFactory = DefaultNameFactory.provider();
        this.datumCache = new Datum[4];
        this.gridMapping = new HashMap<Object, GridMapping>();
        this.localizationGrids = new HashMap<GridCacheKey, GridCacheValue>();
    }

    protected final void initialize() {
        this.convention = Convention.find(this);
    }

    public final void applyOtherConventions() throws IOException, DataStoreException {
        HYCOM.convert(this, this.getVariables());
    }

    public final Convention convention() {
        return this.convention != null ? this.convention : Convention.DEFAULT;
    }

    public abstract void addAttributesTo(TreeTable.Node var1);

    public abstract String getFilename();

    public abstract String[] getFormatDescription();

    public abstract void setSearchPath(String ... var1);

    public abstract String[] getSearchPath();

    public abstract Collection<String> getAttributeNames();

    public abstract String stringValue(String var1);

    public abstract Number numericValue(String var1);

    protected final Number parseNumber(String name, String value) {
        Number n;
        int s = value.indexOf(32);
        if (s >= 0) {
            value = value.substring(0, s);
        }
        try {
            n = value.indexOf(46) >= 0 ? (Number)Double.valueOf(value) : (Number)Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.illegalAttributeValue(name, value, e);
            n = null;
        }
        return n;
    }

    final void illegalAttributeValue(String name, String value, NumberFormatException e) {
        this.listeners.warning(this.resources().getString((short)21, this.getFilename(), name, value), e);
    }

    public abstract Date dateValue(String var1);

    public abstract Date[] numberToDate(String var1, Number ... var2);

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone("UTC");
    }

    public String getId() {
        return this.stringValue("_Id");
    }

    public String getTitle() {
        return this.stringValue("_Title");
    }

    public abstract Variable[] getVariables();

    public DiscreteSampling[] getDiscreteSampling(DataStore lock) throws IOException, DataStoreException {
        String type = this.stringValue("featureType");
        if (type == null || type.equalsIgnoreCase("trajectory")) {
            try {
                return FeatureSet.create(this, lock);
            }
            catch (ArithmeticException | IllegalArgumentException e) {
                throw new DataStoreException(e.getLocalizedMessage(), e);
            }
        }
        return new FeatureSet[0];
    }

    public abstract Grid[] getGridCandidates() throws IOException, DataStoreException;

    public final List<CoordinateReferenceSystem> getReferenceSystemInfo() throws IOException, DataStoreException {
        ArrayList<CoordinateReferenceSystem> list = new ArrayList<CoordinateReferenceSystem>();
        for (Variable variable : this.getVariables()) {
            GridMapping m = GridMapping.forVariable(variable);
            if (m == null) continue;
            Decoder.addIfNotPresent(list, m.crs);
        }
        if (list.isEmpty()) {
            ArrayList<Exception> warnings = new ArrayList<Exception>();
            for (Grid grid : this.getGridCandidates()) {
                Decoder.addIfNotPresent(list, grid.getCoordinateReferenceSystem(this, warnings, null, null));
            }
        }
        return list;
    }

    private static void addIfNotPresent(List<CoordinateReferenceSystem> list, CoordinateReferenceSystem crs) {
        if (crs != null) {
            int i = list.size();
            while (--i >= 0) {
                if (!Utilities.deepEquals(crs, list.get(i), ComparisonMode.ALLOW_VARIANT)) continue;
                return;
            }
            list.add(crs);
        }
    }

    protected abstract Dimension findDimension(String var1);

    protected abstract Variable findVariable(String var1);

    protected abstract Node findNode(String var1);

    final void performance(Class<?> caller, String method, short resourceKey, long time) {
        time = System.nanoTime() - time;
        Level level = PerformanceLevel.forDuration(time, TimeUnit.NANOSECONDS);
        Logger logger = this.listeners.getLogger();
        if (logger.isLoggable(level)) {
            LogRecord record = this.resources().getLogRecord(level, resourceKey, this.getFilename(), (double)time / 1.0E9);
            Logging.completeAndLog(logger, caller, method, record);
        }
    }

    final Resources resources() {
        return Resources.forLocale(this.listeners.getLocale());
    }

    public abstract void close(DataStore var1) throws IOException;
}

