/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.ImageDatum;

@XmlType(name="ImageCRSType", propOrder={"cartesianCS", "affineCS", "datum"})
@XmlRootElement(name="ImageCRS")
public class DefaultImageCRS
extends AbstractCRS
implements ImageCRS {
    private static final long serialVersionUID = 7312452786096397847L;
    private ImageDatum datum;

    public DefaultImageCRS(Map<String, ?> properties, ImageDatum datum, AffineCS cs) {
        super(properties, cs);
        ArgumentChecks.ensureNonNull("datum", datum);
        this.datum = datum;
    }

    protected DefaultImageCRS(ImageCRS crs) {
        super(crs);
        this.datum = crs.getDatum();
    }

    public static DefaultImageCRS castOrCopy(ImageCRS object) {
        return object == null || object instanceof DefaultImageCRS ? (DefaultImageCRS)object : new DefaultImageCRS(object);
    }

    public Class<? extends ImageCRS> getInterface() {
        return ImageCRS.class;
    }

    @Override
    @XmlElement(name="imageDatum", required=true)
    public ImageDatum getDatum() {
        return this.datum;
    }

    @Override
    public AffineCS getCoordinateSystem() {
        return (AffineCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultImageCRS forConvention(AxesConvention convention) {
        return (DefaultImageCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        return new DefaultImageCRS(properties, this.datum, (AffineCS)cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return "ImageCRS";
    }

    private DefaultImageCRS() {
    }

    private void setDatum(ImageDatum value) {
        if (this.datum == null) {
            this.datum = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultImageCRS.class, "setDatum", "imageDatum");
        }
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        return this.getCoordinateSystem(CartesianCS.class);
    }

    @XmlElement(name="affineCS")
    private AffineCS getAffineCS() {
        return this.getCoordinateSystem(AffineCS.class);
    }

    private void setCartesianCS(CartesianCS cs) {
        this.setCoordinateSystem("cartesianCS", cs);
    }

    private void setAffineCS(AffineCS cs) {
        this.setCoordinateSystem("affineCS", cs);
    }
}

