/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.AssociationValue;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.internal.XPath;
import org.apache.sis.pending.geoapi.filter.Name;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.ScopedName;

abstract class PropertyValue<V>
extends LeafExpression<AbstractFeature, V>
implements ValueReference<AbstractFeature, V>,
Optimization.OnExpression<AbstractFeature, V> {
    private static final long serialVersionUID = 3756361632664536269L;
    protected final String name;
    protected final boolean isVirtual;
    static final String VIRTUAL_PREFIX = "/*/";

    protected PropertyValue(String name, boolean isVirtual) {
        this.name = name;
        this.isVirtual = isVirtual;
    }

    @Override
    public final ScopedName getFunctionName() {
        return Name.VALUE_REFERENCE;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <V> ValueReference<AbstractFeature, V> create(String xpath, Class<V> type) {
        void var4_7;
        boolean isVirtual = false;
        List<String> path = XPath.split(xpath);
        if (path != null) {
            String string = path.get(0);
            isVirtual = string.equals("/*");
            if (!isVirtual && string.charAt(0) == '/') throw new IllegalArgumentException(Errors.format((short)195, xpath));
            int offset = isVirtual ? 1 : 0;
            int last = path.size() - 1;
            if (last < offset) throw new IllegalArgumentException(Errors.format((short)195, xpath));
            xpath = path.get(last);
            path = path.subList(offset, last);
        }
        if (type != Object.class) {
            Converted<V> converted = new Converted<V>(type, xpath, isVirtual);
            return path == null || path.isEmpty() ? var4_7 : new AssociationValue(path, var4_7);
        } else {
            AsObject asObject = new AsObject(xpath, isVirtual);
        }
        return path == null || path.isEmpty() ? var4_7 : new AssociationValue(path, var4_7);
    }

    @Override
    public final Class<AbstractFeature> getResourceClass() {
        return AbstractFeature.class;
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.isVirtual ? List.of(this.name, Boolean.valueOf(this.isVirtual)) : List.of(this.name);
    }

    @Override
    public final String getXPath() {
        return this.isVirtual ? VIRTUAL_PREFIX.concat(this.name) : this.name;
    }

    protected Class<?> getSourceClass() {
        return Object.class;
    }

    final PropertyTypeBuilder expectedType(FeatureTypeBuilder addTo) {
        return ((AttributeTypeBuilder)addTo.addAttribute(this.getValueClass()).setName((CharSequence)this.name)).setMinimumOccurs(0);
    }

    public final <N> PropertyValue<N> toValueType(Class<N> target) {
        if (target.equals(this.getValueClass())) {
            return this;
        }
        Class<?> source = this.getSourceClass();
        if (target == Object.class) {
            return new AsObject(this.name, this.isVirtual);
        }
        if (source == Object.class) {
            return new Converted<N>(target, this.name, this.isVirtual);
        }
        return new CastedAndConverted(source, target, this.name, this.isVirtual);
    }

    public abstract PropertyValue<V> optimize(Optimization var1);

    @Override
    public PropertyTypeBuilder expectedType(DefaultFeatureType valueType, FeatureTypeBuilder addTo) {
        AbstractIdentifiedType type;
        try {
            type = valueType.getProperty(this.name);
        }
        catch (IllegalArgumentException e) {
            if (this.isVirtual) {
                return this.expectedType(addTo);
            }
            throw e;
        }
        while (type instanceof AbstractOperation) {
            AbstractIdentifiedType result = ((AbstractOperation)type).getResult();
            if (result != type && result != null) {
                type = result;
                continue;
            }
            if (result instanceof DefaultFeatureType) {
                return addTo.addAssociation((DefaultFeatureType)result).setName((CharSequence)this.name);
            }
            return null;
        }
        return addTo.addProperty(type);
    }

    private static class Converted<V>
    extends PropertyValue<V> {
        private static final long serialVersionUID = -1436865010478207066L;
        protected final Class<V> type;

        protected Converted(Class<V> type, String xpath, boolean isVirtual) {
            super(xpath, isVirtual);
            this.type = type;
        }

        @Override
        public final Class<V> getValueClass() {
            return this.type;
        }

        @Override
        public V apply(AbstractFeature instance) {
            if (instance != null) {
                try {
                    return ObjectConverters.convert(instance.getValueOrFallback(this.name, null), this.type);
                }
                catch (UnconvertibleObjectException e) {
                    this.warning(e, false);
                }
                catch (IllegalArgumentException e) {
                    this.warning(e, true);
                }
            }
            return null;
        }

        @Override
        public final PropertyValue<V> optimize(Optimization optimization) {
            DefaultFeatureType featureType = optimization.getFeatureType();
            if (featureType != null) {
                try {
                    String rename = this.name;
                    AbstractIdentifiedType property = featureType.getProperty(rename);
                    Optional<String> target = Features.getLinkTarget(property);
                    if (target.isPresent()) {
                        try {
                            rename = target.get();
                            property = featureType.getProperty(rename);
                        }
                        catch (IllegalArgumentException e) {
                            this.warning(e, true);
                            rename = this.name;
                        }
                    }
                    Class<Object> source = this.getSourceClass();
                    Class<?> original = source;
                    if (property instanceof DefaultAttributeType) {
                        source = ((DefaultAttributeType)property).getValueClass();
                    }
                    if (!rename.equals(this.name) || !source.equals(original)) {
                        if (source == Object.class) {
                            return new Converted<V>(this.type, rename, this.isVirtual);
                        }
                        return new CastedAndConverted<Object, V>(source, this.type, rename, this.isVirtual);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.warning(e, true);
                }
            }
            return this;
        }

        @Override
        public final PropertyTypeBuilder expectedType(DefaultFeatureType valueType, FeatureTypeBuilder addTo) {
            AttributeTypeBuilder a;
            PropertyTypeBuilder p = super.expectedType(valueType, addTo);
            if (p instanceof AttributeTypeBuilder && !this.type.isAssignableFrom((a = (AttributeTypeBuilder)p).getValueClass())) {
                return a.setValueClass(this.type);
            }
            return p;
        }
    }

    private static final class AsObject
    extends PropertyValue<Object> {
        private static final long serialVersionUID = 2854731969723006038L;

        AsObject(String name, boolean isVirtual) {
            super(name, isVirtual);
        }

        @Override
        public Object apply(AbstractFeature instance) {
            return instance != null ? instance.getValueOrFallback(this.name, null) : null;
        }

        @Override
        public PropertyValue<Object> optimize(Optimization optimization) {
            DefaultFeatureType type = optimization.getFeatureType();
            if (type != null) {
                try {
                    return Features.getLinkTarget(type.getProperty(this.name)).map(rename -> new AsObject((String)rename, this.isVirtual)).orElse(this);
                }
                catch (IllegalArgumentException e) {
                    this.warning(e, true);
                }
            }
            return this;
        }
    }

    private static final class CastedAndConverted<S, V>
    extends Converted<V> {
        private static final long serialVersionUID = -58453954752151703L;
        private final Class<S> source;
        private final ObjectConverter<? super S, ? extends V> converter;

        CastedAndConverted(Class<S> source, Class<V> type, String xpath, boolean isVirtual) {
            super(type, xpath, isVirtual);
            this.source = source;
            this.converter = ObjectConverters.find(source, type);
        }

        @Override
        protected Class<S> getSourceClass() {
            return this.source;
        }

        @Override
        public V apply(AbstractFeature instance) {
            if (instance != null) {
                try {
                    return this.converter.apply(this.source.cast(instance.getValueOrFallback(this.name, null)));
                }
                catch (ClassCastException | UnconvertibleObjectException e) {
                    this.warning(e, false);
                }
                catch (IllegalArgumentException e) {
                    this.warning(e, true);
                }
            }
            return null;
        }
    }
}

