/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.feature.internal.FeatureExpression;
import org.apache.sis.filter.BinaryFunction;
import org.apache.sis.filter.ConvertFunction;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.math.Fraction;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.ScopedName;

abstract class ArithmeticFunction<R>
extends BinaryFunction<R, Number, Number>
implements FeatureExpression<R, Number>,
Optimization.OnExpression<R, Number> {
    private static final long serialVersionUID = 2818625862630588268L;

    ArithmeticFunction(Expression<R, ? extends Number> expression1, Expression<R, ? extends Number> expression2) {
        super(expression1, expression2);
    }

    static DefaultAttributeType<Number> createNumericType(String name) {
        return ArithmeticFunction.createType(Number.class, name);
    }

    protected abstract DefaultAttributeType<Number> expectedType();

    @Override
    public final Class<?> getValueClass() {
        return Number.class;
    }

    @Override
    public final PropertyTypeBuilder expectedType(DefaultFeatureType ignored, FeatureTypeBuilder addTo) {
        return addTo.addProperty(this.expectedType());
    }

    @Override
    public final Number apply(R feature) {
        Number right;
        Number left = (Number)this.expression1.apply(feature);
        if (left != null && (right = (Number)this.expression2.apply(feature)) != null) {
            return this.apply(left, right);
        }
        return null;
    }

    @Override
    public <N> Expression<R, N> toValueType(Class<N> target) {
        if (target.isAssignableFrom(Number.class)) {
            return this;
        }
        try {
            return new ConvertFunction(this, Number.class, target);
        }
        catch (UnconvertibleObjectException e) {
            throw (ClassCastException)new ClassCastException(Errors.format((short)8, this.getFunctionName(), target)).initCause(e);
        }
    }

    static final class Divide<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = -7709291845568648891L;
        private static final DefaultAttributeType<Number> TYPE = Divide.createNumericType("Divide");
        private static final ScopedName NAME = Divide.createName("Divide");

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        Divide(Expression<R, ? extends Number> expression1, Expression<R, ? extends Number> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<R, ?>[] effective) {
            return new Divide<R>(effective[0].toValueType(Number.class), effective[1].toValueType(Number.class));
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '\u00f7';
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return left / right;
        }

        @Override
        protected Number applyAsFraction(Fraction left, Fraction right) {
            return left.divide(right);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal left, BigDecimal right) {
            return left.divide(right);
        }

        @Override
        protected Number applyAsInteger(BigInteger left, BigInteger right) {
            BigInteger[] r = left.divideAndRemainder(right);
            if (BigInteger.ZERO.equals(r[1])) {
                return r[0];
            }
            return Fraction.valueOf(r[1].longValueExact(), right.longValueExact()).add(new Fraction(r[0].intValueExact(), 1));
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            long r = left / right;
            if (left % right == 0L) {
                return r;
            }
            return Fraction.valueOf(left, right);
        }
    }

    static final class Multiply<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = -1300022614832645625L;
        private static final DefaultAttributeType<Number> TYPE = Multiply.createNumericType("Multiply");
        private static final ScopedName NAME = Multiply.createName("Multiply");

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        Multiply(Expression<R, ? extends Number> expression1, Expression<R, ? extends Number> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<R, ?>[] effective) {
            return new Multiply<R>(effective[0].toValueType(Number.class), effective[1].toValueType(Number.class));
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '\u00d7';
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return left * right;
        }

        @Override
        protected Number applyAsFraction(Fraction left, Fraction right) {
            return left.multiply(right);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal left, BigDecimal right) {
            return left.multiply(right);
        }

        @Override
        protected Number applyAsInteger(BigInteger left, BigInteger right) {
            return left.multiply(right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return Math.multiplyExact(left, right);
        }
    }

    static final class Subtract<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = 3048878022726271508L;
        private static final DefaultAttributeType<Number> TYPE = Subtract.createNumericType("Subtract");
        private static final ScopedName NAME = Subtract.createName("Subtract");

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        Subtract(Expression<R, ? extends Number> expression1, Expression<R, ? extends Number> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<R, ?>[] effective) {
            return new Subtract<R>(effective[0].toValueType(Number.class), effective[1].toValueType(Number.class));
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '\u2212';
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return left - right;
        }

        @Override
        protected Number applyAsFraction(Fraction left, Fraction right) {
            return left.subtract(right);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal left, BigDecimal right) {
            return left.subtract(right);
        }

        @Override
        protected Number applyAsInteger(BigInteger left, BigInteger right) {
            return left.subtract(right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return Math.subtractExact(left, right);
        }
    }

    static final class Add<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = 5445433312445869201L;
        private static final DefaultAttributeType<Number> TYPE = Add.createNumericType("Add");
        private static final ScopedName NAME = Add.createName("Add");

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        Add(Expression<R, ? extends Number> expression1, Expression<R, ? extends Number> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<R, ?>[] effective) {
            return new Add<R>(effective[0].toValueType(Number.class), effective[1].toValueType(Number.class));
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '+';
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return left + right;
        }

        @Override
        protected Number applyAsFraction(Fraction left, Fraction right) {
            return left.add(right);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal left, BigDecimal right) {
            return left.add(right);
        }

        @Override
        protected Number applyAsInteger(BigInteger left, BigInteger right) {
            return left.add(right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return Math.addExact(left, right);
        }
    }
}

