/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.CopyTransform;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.referencing.operation.transform.IdentityTransform;
import org.apache.sis.referencing.operation.transform.LinearInterpolator1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform2D;
import org.apache.sis.referencing.operation.transform.ScaleTransform;
import org.apache.sis.referencing.operation.transform.SpecializableTransform;
import org.apache.sis.referencing.operation.transform.SpecializableTransform2D;
import org.apache.sis.referencing.operation.transform.TransformAdapter2D;
import org.apache.sis.referencing.operation.transform.TranslationTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class MathTransforms
extends Static {
    private MathTransforms() {
    }

    public static LinearTransform identity(int n) {
        ArgumentChecks.ensurePositive("dimension", n);
        return IdentityTransform.create(n);
    }

    public static LinearTransform uniformTranslation(int n, double d) {
        ArgumentChecks.ensurePositive("dimension", n);
        if (d == 0.0) {
            return IdentityTransform.create(n);
        }
        switch (n) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(1.0, d);
            }
            case 2: {
                return new AffineTransform2D(1.0, 0.0, 0.0, 1.0, d, d);
            }
        }
        return new TranslationTransform(n, d);
    }

    public static LinearTransform translation(double ... dArray) {
        LinearTransform linearTransform;
        ArgumentChecks.ensureNonNull("vector", dArray);
        switch (dArray.length) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(1.0, dArray[0]);
            }
            case 2: {
                linearTransform = new AffineTransform2D(1.0, 0.0, 0.0, 1.0, dArray[0], dArray[1]);
                break;
            }
            default: {
                linearTransform = new TranslationTransform(dArray);
            }
        }
        return linearTransform.isIdentity() ? IdentityTransform.create(dArray.length) : linearTransform;
    }

    public static LinearTransform scale(double ... dArray) {
        LinearTransform linearTransform;
        ArgumentChecks.ensureNonNull("factors", dArray);
        switch (dArray.length) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(dArray[0], 0.0);
            }
            case 2: {
                linearTransform = new AffineTransform2D(dArray[0], 0.0, 0.0, dArray[1], 0.0, 0.0);
                break;
            }
            default: {
                linearTransform = new ScaleTransform(dArray);
            }
        }
        return linearTransform.isIdentity() ? IdentityTransform.create(dArray.length) : linearTransform;
    }

    public static LinearTransform linear(double d, double d2) {
        return LinearTransform1D.create(d, d2);
    }

    public static LinearTransform linear(Matrix matrix) {
        CopyTransform copyTransform;
        ArgumentChecks.ensureNonNull("matrix", matrix);
        int n = matrix.getNumCol() - 1;
        int n2 = matrix.getNumRow() - 1;
        if (n == n2) {
            if (matrix.isIdentity()) {
                return MathTransforms.identity(n);
            }
            if (Matrices.isAffine(matrix)) {
                switch (n) {
                    case 1: {
                        return MathTransforms.linear(matrix.getElement(0, 0), matrix.getElement(0, 1));
                    }
                    case 2: {
                        if (matrix instanceof ExtendedPrecisionMatrix) {
                            return new AffineTransform2D((ExtendedPrecisionMatrix)matrix);
                        }
                        return new AffineTransform2D(matrix.getElement(0, 0), matrix.getElement(1, 0), matrix.getElement(0, 1), matrix.getElement(1, 1), matrix.getElement(0, 2), matrix.getElement(1, 2));
                    }
                }
            } else if (n == 2) {
                return new ProjectiveTransform2D(matrix);
            }
        }
        if ((copyTransform = CopyTransform.create(matrix)) != null) {
            return copyTransform;
        }
        return new ProjectiveTransform(matrix).optimize();
    }

    public static LinearTransform linear(MathTransform mathTransform, DirectPosition directPosition) throws TransformException {
        if (mathTransform instanceof LinearTransform) {
            ArgumentChecks.ensureDimensionMatches("position", mathTransform.getSourceDimensions(), directPosition);
            return (LinearTransform)mathTransform;
        }
        return MathTransforms.linear(MathTransforms.getMatrix(mathTransform, directPosition));
    }

    public static MathTransform1D interpolate(double[] dArray, double[] dArray2) {
        return LinearInterpolator1D.create(dArray, dArray2);
    }

    public static MathTransform specialize(MathTransform mathTransform, Map<Envelope, MathTransform> map) {
        ArgumentChecks.ensureNonNull("generic", mathTransform);
        ArgumentChecks.ensureNonNull("specializations", map);
        if (map.isEmpty()) {
            return mathTransform;
        }
        SpecializableTransform specializableTransform = mathTransform.getSourceDimensions() == 2 && mathTransform.getTargetDimensions() == 2 ? new SpecializableTransform2D(mathTransform, map) : new SpecializableTransform(mathTransform, map);
        MathTransform mathTransform2 = specializableTransform.getSubstitute();
        return mathTransform2 != null ? mathTransform2 : specializableTransform;
    }

    public static MathTransform passThrough(int n, MathTransform mathTransform, int n2) {
        int n3;
        ArgumentChecks.ensureNonNull("subTransform", mathTransform);
        ArgumentChecks.ensurePositive("firstAffectedCoordinate", n);
        ArgumentChecks.ensurePositive("numTrailingCoordinates", n2);
        if (n == 0 && n2 == 0) {
            return mathTransform;
        }
        if (mathTransform.isIdentity() && (n3 = mathTransform.getSourceDimensions()) == mathTransform.getTargetDimensions()) {
            return IdentityTransform.create(n + n3 + n2);
        }
        return PassThroughTransform.create(n, mathTransform, n2);
    }

    public static MathTransform compound(MathTransform ... mathTransformArray) {
        ArgumentChecks.ensureNonNull("components", mathTransformArray);
        int n = 0;
        int[] nArray = new int[mathTransformArray.length];
        for (int i = 0; i < mathTransformArray.length; ++i) {
            MathTransform mathTransform = mathTransformArray[i];
            ArgumentChecks.ensureNonNullElement("components", i, mathTransform);
            nArray[i] = mathTransform.getSourceDimensions();
            n += nArray[i];
        }
        MathTransform mathTransform = null;
        int n2 = 0;
        for (int i = 0; i < mathTransformArray.length; ++i) {
            MathTransform mathTransform2 = mathTransformArray[i];
            mathTransform2 = MathTransforms.passThrough(n2, mathTransform2, n - (n2 += nArray[i]));
            mathTransform = mathTransform == null ? mathTransform2 : MathTransforms.concatenate(mathTransform, mathTransform2);
        }
        assert (MathTransforms.isValid(MathTransforms.getSteps(mathTransform))) : mathTransform;
        return mathTransform;
    }

    public static MathTransform concatenate(MathTransform mathTransform, MathTransform mathTransform2) throws MismatchedDimensionException {
        MathTransform mathTransform3;
        ArgumentChecks.ensureNonNull("tr1", mathTransform);
        ArgumentChecks.ensureNonNull("tr2", mathTransform2);
        try {
            mathTransform3 = ConcatenatedTransform.create(mathTransform, mathTransform2, null);
        }
        catch (FactoryException factoryException) {
            throw new IllegalArgumentException(factoryException);
        }
        assert (MathTransforms.isValid(MathTransforms.getSteps(mathTransform3))) : mathTransform3;
        return mathTransform3;
    }

    public static MathTransform1D concatenate(MathTransform1D mathTransform1D, MathTransform1D mathTransform1D2) throws MismatchedDimensionException {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)mathTransform1D, (MathTransform)mathTransform1D2);
    }

    public static MathTransform2D concatenate(MathTransform2D mathTransform2D, MathTransform2D mathTransform2D2) throws MismatchedDimensionException {
        return MathTransforms.bidimensional(MathTransforms.concatenate((MathTransform)mathTransform2D, (MathTransform)mathTransform2D2));
    }

    public static MathTransform concatenate(MathTransform mathTransform, MathTransform mathTransform2, MathTransform mathTransform3) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("tr1", mathTransform);
        ArgumentChecks.ensureNonNull("tr2", mathTransform2);
        ArgumentChecks.ensureNonNull("tr3", mathTransform3);
        return MathTransforms.concatenate(MathTransforms.concatenate(mathTransform, mathTransform2), mathTransform3);
    }

    public static MathTransform1D concatenate(MathTransform1D mathTransform1D, MathTransform1D mathTransform1D2, MathTransform1D mathTransform1D3) throws MismatchedDimensionException {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)mathTransform1D, (MathTransform)mathTransform1D2, (MathTransform)mathTransform1D3);
    }

    public static MathTransform2D concatenate(MathTransform2D mathTransform2D, MathTransform2D mathTransform2D2, MathTransform2D mathTransform2D3) throws MismatchedDimensionException {
        return MathTransforms.bidimensional(MathTransforms.concatenate((MathTransform)mathTransform2D, (MathTransform)mathTransform2D2, (MathTransform)mathTransform2D3));
    }

    public static MathTransform2D bidimensional(MathTransform mathTransform) {
        if (mathTransform == null || mathTransform instanceof MathTransform2D) {
            return (MathTransform2D)mathTransform;
        }
        ArgumentChecks.ensureDimensionsMatch("transform", 2, 2, mathTransform);
        return new TransformAdapter2D(mathTransform);
    }

    static boolean isValid(List<MathTransform> list) {
        boolean bl = false;
        for (MathTransform mathTransform : list) {
            if (mathTransform instanceof LinearTransform) {
                if (bl) {
                    return false;
                }
                bl = true;
                continue;
            }
            bl = false;
        }
        return true;
    }

    public static List<MathTransform> getSteps(MathTransform mathTransform) {
        if (mathTransform != null) {
            if (mathTransform instanceof ConcatenatedTransform) {
                return ((ConcatenatedTransform)mathTransform).getSteps();
            }
            return Collections.singletonList(mathTransform);
        }
        return Collections.emptyList();
    }

    public static Matrix getMatrix(MathTransform mathTransform) {
        if (mathTransform instanceof LinearTransform) {
            return ((LinearTransform)mathTransform).getMatrix();
        }
        if (mathTransform instanceof AffineTransform) {
            return AffineTransforms2D.toMatrix((AffineTransform)((Object)mathTransform));
        }
        return null;
    }

    public static Matrix getMatrix(MathTransform mathTransform, DirectPosition directPosition) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", mathTransform);
        int n = mathTransform.getSourceDimensions();
        ArgumentChecks.ensureDimensionMatches("position", n, directPosition);
        Matrix matrix = MathTransforms.getMatrix(mathTransform);
        if (matrix != null) {
            return matrix;
        }
        ArgumentChecks.ensureNonNull("position", directPosition);
        int n2 = mathTransform.getTargetDimensions();
        double[] dArray = new double[Math.max(n + 1, n2)];
        for (int i = 0; i < n; ++i) {
            dArray[i] = directPosition.getOrdinate(i);
        }
        Matrix matrix2 = MathTransforms.derivativeAndTransform(mathTransform, dArray, 0, dArray, 0);
        MatrixSIS matrixSIS = Matrices.createZero(n2 + 1, n + 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                matrixSIS.setElement(i, j, matrix2.getElement(i, j));
            }
            matrixSIS.setElement(i, n, dArray[i]);
            dArray[i] = -directPosition.getOrdinate(i);
        }
        matrixSIS.setElement(n2, n, 1.0);
        dArray = ArraysExt.resize(dArray, n + 1);
        dArray[n] = 1.0;
        matrixSIS.translate(dArray);
        return matrixSIS;
    }

    public static Matrix derivativeAndTransform(MathTransform mathTransform, double[] dArray, int n, double[] dArray2, int n2) throws TransformException {
        if (mathTransform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)mathTransform).transform(dArray, n, dArray2, n2, true);
        }
        Matrix matrix = mathTransform.derivative(new DirectPositionView.Double(dArray, n, mathTransform.getSourceDimensions()));
        if (dArray2 != null) {
            mathTransform.transform(dArray, n, dArray2, n2, 1);
        }
        return matrix;
    }

    public static LinearTransform tangent(MathTransform mathTransform, DirectPosition directPosition) throws TransformException {
        ArgumentChecks.ensureNonNull("toApproximate", mathTransform);
        if (mathTransform instanceof LinearTransform) {
            return (LinearTransform)mathTransform;
        }
        int n = mathTransform.getSourceDimensions();
        ArgumentChecks.ensureDimensionMatches("tangentPoint", n, directPosition);
        int n2 = mathTransform.getTargetDimensions();
        double[] dArray = new double[Math.max(n, n2)];
        for (int i = 0; i < n; ++i) {
            dArray[i] = directPosition.getOrdinate(i);
        }
        Matrix matrix = MathTransforms.derivativeAndTransform(mathTransform, dArray, 0, dArray, 0);
        MatrixSIS matrixSIS = Matrices.createAffine(matrix, new DirectPositionView.Double(dArray, 0, n2));
        for (int i = 0; i < n; ++i) {
            matrixSIS.convertBefore(i, null, -directPosition.getOrdinate(i));
        }
        LinearTransform linearTransform = MathTransforms.linear(matrixSIS);
        assert (linearTransform.getSourceDimensions() == n);
        assert (linearTransform.getTargetDimensions() == n2);
        return linearTransform;
    }

    public static Optional<Envelope> getDomain(MathTransform mathTransform) throws TransformException {
        if (mathTransform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)mathTransform).getDomain(new DomainDefinition());
        }
        return Optional.empty();
    }
}

