/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.internal.referencing.provider.Mercator2SP;
import org.apache.sis.internal.referencing.provider.MercatorAuxiliarySphere;
import org.apache.sis.internal.referencing.provider.RegionalMercator;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.AuthalicMercator;
import org.apache.sis.referencing.operation.projection.ConformalProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class Mercator
extends ConformalProjection {
    private static final long serialVersionUID = 8732555724521630563L;
    private final Variant variant;

    public Mercator(OperationMethod operationMethod, Parameters parameters) {
        this(Mercator.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        Variant variant = (Variant)Mercator.variant((OperationMethod)operationMethod, (ProjectionVariant[])Variant.values(), (ProjectionVariant)Variant.TWO_PARALLELS);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, Mercator1SP.SCALE_FACTOR);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, Mercator1SP.LONGITUDE_OF_ORIGIN);
        switch (variant) {
            case REGIONAL: {
                enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, RegionalMercator.EASTING_AT_FALSE_ORIGIN);
                enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, RegionalMercator.NORTHING_AT_FALSE_ORIGIN);
                break;
            }
            case SPHERICAL: {
                enumMap.put(NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS, Mercator1SP.LATITUDE_OF_ORIGIN);
            }
            default: {
                enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, Mercator1SP.FALSE_EASTING);
                enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, Mercator1SP.FALSE_NORTHING);
            }
        }
        return new Initializer(operationMethod, parameters, enumMap, variant);
    }

    private Mercator(Initializer initializer) {
        super(initializer);
        DoubleDouble doubleDouble;
        this.variant = (Variant)initializer.variant;
        double d = initializer.getAndStore(Mercator1SP.LONGITUDE_OF_ORIGIN);
        double d2 = Math.toRadians(initializer.getAndStore(this.variant == Variant.REGIONAL ? RegionalMercator.LATITUDE_OF_FALSE_ORIGIN : Mercator1SP.LATITUDE_OF_ORIGIN));
        double d3 = Math.toRadians(initializer.getAndStore(Mercator2SP.STANDARD_PARALLEL));
        DoubleDouble doubleDouble2 = new DoubleDouble(initializer.scaleAt\u03c6(Math.sin(d3), Math.cos(d3)));
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS matrixSIS2 = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS2.convertBefore(0, doubleDouble2, null);
        matrixSIS2.convertBefore(1, doubleDouble2, null);
        if (d2 != 0.0) {
            matrixSIS2.convertBefore(1, null, new DoubleDouble(-Math.log(this.exp\u03a8(d2, this.eccentricity * Math.sin(d2)))));
        }
        if (this.variant == Variant.MILLER) {
            matrixSIS.convertBefore(1, 0.8, null);
            matrixSIS2.convertBefore(1, 1.25, null);
        } else if (this.variant == Variant.AUXILIARY) {
            doubleDouble = null;
            int n = initializer.getAndStore(MercatorAuxiliarySphere.AUXILIARY_SPHERE_TYPE, 0);
            switch (n) {
                default: {
                    throw new IllegalArgumentException(Errors.format((short)45, MercatorAuxiliarySphere.AUXILIARY_SPHERE_TYPE.getName().getCode(), n));
                }
                case 2: 
                case 3: {
                    doubleDouble = new DoubleDouble(Formulas.getAuthalicRadius(1.0, initializer.axisLengthRatio().value));
                    break;
                }
                case 1: {
                    doubleDouble = initializer.axisLengthRatio();
                }
                case 0: 
            }
            matrixSIS2.convertAfter(0, doubleDouble, null);
            matrixSIS2.convertAfter(1, doubleDouble, null);
        }
        if (d2 == 0.0 && MathFunctions.isPositive(d3 != 0.0 ? d3 : d2)) {
            doubleDouble = new DoubleDouble(-1.0);
            matrixSIS.convertBefore(1, doubleDouble, null);
            matrixSIS2.convertBefore(1, doubleDouble, null);
        }
    }

    Mercator(Mercator mercator) {
        super(mercator);
        this.variant = mercator.variant;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        NormalizedProjection normalizedProjection = this;
        if (this.variant.spherical || this.eccentricity == 0.0 && this.getClass() == Mercator.class) {
            int n;
            normalizedProjection = this.variant == Variant.AUXILIARY && this.eccentricity != 0.0 && (n = this.context.getValue(MercatorAuxiliarySphere.AUXILIARY_SPHERE_TYPE).intValue()) == 3 ? new AuthalicMercator(this) : new Spherical(this);
        }
        return normalizedProjection.completeWithWraparound(mathTransformFactory);
    }

    @Override
    public Optional<Envelope> getDomain(DomainDefinition domainDefinition) {
        double d = this.variant == Variant.MILLER ? -1.5707963267948966 : -1.4660765716752369;
        return Optional.of(new Envelope2D(null, -314.1592653589793, d, 628.3185307179587, -2.0 * d));
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n + 1];
        double d2 = Math.sin(d);
        if (dArray2 != null) {
            double d3;
            double d4 = d == 0.0 ? d : ((d3 = Math.abs(d)) < 1.5707963267948966 ? Math.log(this.exp\u03a8(d, this.eccentricity * d2)) : (d3 <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, d) : Double.NaN));
            dArray2[n2] = dArray[n];
            dArray2[n2 + 1] = d4;
        }
        return bl ? new Matrix2(1.0, 0.0, 0.0, this.dy_d\u03c6(d2, Math.cos(d))) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (dArray != dArray2 || n != n2 || this.getClass() != Mercator.class) {
            super.transform(dArray, n, dArray2, n2, n3);
        } else {
            --n2;
            while (--n3 >= 0) {
                double d = dArray2[n2 += 2];
                if (d == 0.0) continue;
                double d2 = Math.abs(d);
                double d3 = d2 < 1.5707963267948966 ? Math.log(this.exp\u03a8(d, this.eccentricity * Math.sin(d))) : (d2 <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, d) : Double.NaN);
                dArray2[n2] = d3;
            }
        }
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n + 1];
        dArray2[n2] = dArray[n];
        dArray2[n2 + 1] = this.\u03c6(Math.exp(-d));
    }

    @Override
    final MathTransform tryConcatenate(boolean bl, Matrix matrix, MathTransformFactory mathTransformFactory) throws FactoryException {
        if (matrix.getElement(1, 0) == 0.0 && matrix.getElement(1, 2) == 0.0 && Math.abs(matrix.getElement(1, 1)) == 1.0) {
            if (mathTransformFactory != null) {
                return mathTransformFactory.createAffineTransform(matrix);
            }
            return MathTransforms.linear(matrix);
        }
        return super.tryConcatenate(bl, matrix, mathTransformFactory);
    }

    private static enum Variant implements ProjectionVariant
    {
        ONE_PARALLEL(".*\\bvariant\\s*A\\b.*", "9804", false),
        TWO_PARALLELS(".*\\bvariant\\s*B\\b.*", "9805", false),
        REGIONAL(".*\\bvariant\\s*C\\b.*", "1044", false),
        SPHERICAL(".*\\bSpherical\\b.*", "1026", true),
        PSEUDO(".*\\bPseudo.*", "1024", true),
        AUXILIARY(".*\\bAuxiliary\\s*Sphere\\b.*", null, true),
        MILLER(".*\\bMiller.*", null, false);

        private final Pattern operationName;
        private final String identifier;
        final boolean spherical;

        private Variant(String string2, String string3, boolean bl) {
            this.operationName = Pattern.compile(string2, 2);
            this.identifier = string3;
            this.spherical = bl;
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    static final class Spherical
    extends Mercator {
        private static final long serialVersionUID = 2383414176395616561L;

        Spherical(Mercator mercator) {
            super(mercator);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
            double d = dArray[n + 1];
            if (dArray2 != null) {
                double d2;
                double d3 = d == 0.0 ? d : ((d2 = Math.abs(d)) < 1.5707963267948966 ? Math.log(Math.tan(0.7853981633974483 + 0.5 * d)) : (d2 <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, d) : Double.NaN));
                dArray2[n2] = dArray[n];
                dArray2[n2 + 1] = d3;
            }
            return bl ? new Matrix2(1.0, 0.0, 0.0, 1.0 / Math.cos(d)) : null;
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            if (dArray != dArray2 || n != n2) {
                super.transform(dArray, n, dArray2, n2, n3);
            } else {
                --n2;
                while (--n3 >= 0) {
                    double d = dArray2[n2 += 2];
                    if (d == 0.0) continue;
                    double d2 = Math.abs(d);
                    double d3 = d2 < 1.5707963267948966 ? Math.log(Math.tan(0.7853981633974483 + 0.5 * d)) : (d2 <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, d) : Double.NaN);
                    dArray2[n2] = d3;
                }
            }
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
            double d = dArray[n + 1];
            dArray2[n2] = dArray[n];
            dArray2[n2 + 1] = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-d));
        }
    }
}

