/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.util.Arrays;
import java.util.function.Function;
import javax.measure.quantity.Dimensionless;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.builder.ProjectedTransformTry;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class ResidualGrid
extends DatumShiftGrid<Dimensionless, Dimensionless> {
    private static final long serialVersionUID = -3668228260650927123L;
    static final int SOURCE_DIMENSION = 2;
    private static final ParameterDescriptorGroup PARAMETERS;
    private final int scanlineStride;
    private final float[] offsets;
    final LinearTransform gridToTarget;
    private final double accuracy;
    private final double[] periodVector;

    @Override
    public void getParameterValues(Parameters parameters) {
        Matrix matrix = this.gridToTarget.getMatrix();
        if (parameters instanceof ContextualParameters) {
            MatrixSIS matrixSIS = ((ContextualParameters)parameters).getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
            matrixSIS.setMatrix(matrix);
        }
        parameters.parameter("num_row").setValue(this.getGridSize(1));
        parameters.parameter("num_col").setValue(this.getGridSize(0));
        parameters.parameter("grid_x").setValue(new Data(0, matrix));
        parameters.parameter("grid_y").setValue(new Data(1, matrix));
    }

    ResidualGrid(LinearTransform linearTransform, LinearTransform linearTransform2, int n, int n2, float[] fArray, double d, double[] dArray, ProjectedTransformTry projectedTransformTry) throws TransformException {
        super(Units.UNITY, linearTransform, new int[]{n, n2}, true, Units.UNITY);
        this.gridToTarget = linearTransform2;
        this.offsets = fArray;
        this.accuracy = d;
        this.scanlineStride = n;
        if (dArray != null && projectedTransformTry == null && linearTransform2.isAffine()) {
            MatrixSIS matrixSIS = MatrixSIS.castOrCopy(linearTransform2.inverse().derivative(null));
            this.periodVector = matrixSIS.multiply(dArray);
        } else {
            this.periodVector = null;
        }
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return PARAMETERS;
    }

    @Override
    public int getTranslationDimensions() {
        return 2;
    }

    @Override
    public double getCellPrecision() {
        return this.accuracy;
    }

    @Override
    public double getCellValue(int n, int n2, int n3) {
        return this.offsets[(n2 + n3 * this.scanlineStride) * 2 + n];
    }

    @Override
    protected void replaceOutsideGridCoordinates(double[] dArray) {
        if (this.periodVector != null) {
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = this.periodVector[i];
                double d4 = dArray[i];
                double d5 = d4 - (double)(this.getGridSize(i) - 1);
                d4 = Math.floor(d4 / d3);
                d5 = Math.ceil(d5 / d3);
                if (d4 < d2) {
                    d2 = d4;
                }
                if (!(d5 > d)) continue;
                d = d5;
            }
            if (d <= d2) {
                double d6;
                double d7 = d6 = d >= 0.0 ? d : d2;
                if (Double.isFinite(d6)) {
                    for (int i = 0; i < dArray.length; ++i) {
                        int n = i;
                        dArray[n] = dArray[n] - this.periodVector[i] * d6;
                    }
                }
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ResidualGrid residualGrid = (ResidualGrid)object;
            return Numerics.equals(this.accuracy, residualGrid.accuracy) && this.gridToTarget.equals(residualGrid.gridToTarget) && Arrays.equals(this.offsets, residualGrid.offsets);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.offsets) + 37 * this.gridToTarget.hashCode();
    }

    static {
        ParameterBuilder parameterBuilder = new ParameterBuilder().setRequired(true);
        GeneralParameterDescriptor[] generalParameterDescriptorArray = new ParameterDescriptor[]{((ParameterBuilder)parameterBuilder.addName("num_row")).createBounded(Integer.class, Integer.valueOf(2), null, null), ((ParameterBuilder)parameterBuilder.addName("num_col")).createBounded(Integer.class, Integer.valueOf(2), null, null), ((ParameterBuilder)parameterBuilder.addName("grid_x")).create(Matrix.class, null), ((ParameterBuilder)parameterBuilder.addName("grid_y")).create(Matrix.class, null)};
        PARAMETERS = ((ParameterBuilder)parameterBuilder.addName("Localization grid")).createGroup(generalParameterDescriptorArray);
    }

    private final class Data
    extends FormattableObject
    implements Matrix,
    Function<int[], Number> {
        private final double c0;
        private final double c1;
        private final double c2;

        Data(int n, Matrix matrix) {
            this.c0 = matrix.getElement(n, 0);
            this.c1 = matrix.getElement(n, 1);
            this.c2 = matrix.getElement(n, 2);
        }

        @Override
        public Matrix clone() {
            return this;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public int getNumCol() {
            return ResidualGrid.this.getGridSize(0);
        }

        @Override
        public int getNumRow() {
            return ResidualGrid.this.getGridSize(1);
        }

        @Override
        public Number apply(int[] nArray) {
            return this.getElement(nArray[1], nArray[0]);
        }

        @Override
        public void setElement(int n, int n2, double d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getElement(int n, int n2) {
            if ((n2 | n) < 0 || n2 >= ResidualGrid.this.scanlineStride) {
                throw new IndexOutOfBoundsException();
            }
            return this.c0 * ((double)n2 + ResidualGrid.this.getCellValue(0, n2, n)) + this.c1 * ((double)n + ResidualGrid.this.getCellValue(1, n2, n)) + this.c2;
        }

        @Override
        public String toString() {
            return new StringBuilder(80).append('[').append(this.getElement(0, 0)).append(", \u2026, ").append(this.getElement(ResidualGrid.this.getGridSize(1) - 1, ResidualGrid.this.getGridSize(0) - 1)).append(']').toString();
        }

        @Override
        protected String formatTo(Formatter formatter) {
            int n;
            Object[] objectArray = WKTUtilities.cornersAndCenter(this, ResidualGrid.this.getGridSize(), 3);
            Vector[] vectorArray = new Vector[objectArray.length];
            Statistics statistics = new Statistics(null);
            Vector vector = null;
            for (n = 0; n < vectorArray.length; ++n) {
                Vector vector2 = Vector.create(objectArray[n], false);
                Number number = null;
                int n2 = vector2.size();
                while (--n2 >= 0) {
                    Number number2 = vector2.get(n2);
                    if (number2 != null) {
                        Number number3;
                        double d = number2.doubleValue();
                        if (number != null) {
                            statistics.accept(Math.abs(number.doubleValue() - d));
                        }
                        if (vector != null && (number3 = vector.get(n2)) != null) {
                            statistics.accept(Math.abs(number3.doubleValue() - d));
                        }
                    }
                    number = number2;
                }
                vector = vector2;
                vectorArray[n] = vector2;
            }
            n = Numerics.suggestFractionDigits(statistics);
            formatter.newLine();
            formatter.append(vectorArray, Math.max(0, n));
            formatter.setInvalidWKT(Matrix.class, null);
            return "Matrix";
        }
    }
}

