/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.referencing.CC_OperationMethod;
import org.apache.sis.internal.jaxb.referencing.CC_OperationParameterGroup;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.GeodeticException;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultTransformation;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

@XmlType(name="AbstractSingleOperationType", propOrder={"method", "parameters"})
@XmlRootElement(name="AbstractSingleOperation")
@XmlSeeAlso(value={DefaultConversion.class, DefaultTransformation.class})
class AbstractSingleOperation
extends AbstractCoordinateOperation
implements SingleOperation,
Parameterized {
    private static final long serialVersionUID = -2635450075620911309L;
    private OperationMethod method;
    ParameterValueGroup parameters;

    public AbstractSingleOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3, OperationMethod operationMethod, MathTransform mathTransform) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, mathTransform);
        ArgumentChecks.ensureNonNull("method", operationMethod);
        ArgumentChecks.ensureNonNull("transform", mathTransform);
        this.method = operationMethod;
        this.setParameterValues(Containers.property(map, "parameters", ParameterValueGroup.class), null);
    }

    AbstractSingleOperation(Map<String, ?> map, OperationMethod operationMethod) {
        super(map);
        ArgumentChecks.ensureNonNull("method", operationMethod);
        this.method = operationMethod;
    }

    protected AbstractSingleOperation(SingleOperation singleOperation) {
        super(singleOperation);
        this.method = singleOperation.getMethod();
        this.parameters = Parameters.unmodifiable(singleOperation.getParameterValues());
    }

    @Override
    @XmlElement(name="method", required=true)
    public OperationMethod getMethod() {
        return this.method;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.parameters != null ? this.parameters.getDescriptor() : super.getParameterDescriptors();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.parameters != null ? this.parameters : super.getParameterValues();
    }

    final void setParameterValues(ParameterValueGroup parameterValueGroup, Map<String, Boolean> map) {
        Predicate<GeneralParameterDescriptor> predicate = null;
        if (map != null) {
            for (GeneralParameterDescriptor generalParameterDescriptor2 : this.method.getParameters().descriptors()) {
                map.remove(generalParameterDescriptor2.getName().getCode());
                for (GenericName genericName : generalParameterDescriptor2.getAlias()) {
                    map.remove(genericName.tip().toString());
                }
            }
            predicate = generalParameterDescriptor -> {
                Boolean bl;
                block1: {
                    GenericName genericName;
                    bl = (Boolean)map.get(generalParameterDescriptor.getName().getCode());
                    if (bl != null) break block1;
                    Iterator<GenericName> iterator = generalParameterDescriptor.getAlias().iterator();
                    while (iterator.hasNext() && (bl = (Boolean)map.get((genericName = iterator.next()).tip().toString())) == null) {
                    }
                }
                return !Boolean.TRUE.equals(bl);
            };
        }
        this.parameters = Parameters.unmodifiable(parameterValueGroup, predicate);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                AbstractSingleOperation abstractSingleOperation = (AbstractSingleOperation)object;
                return Objects.equals(this.method, abstractSingleOperation.method) && Objects.equals(this.parameters, abstractSingleOperation.parameters);
            }
            case BY_CONTRACT: {
                SingleOperation singleOperation = (SingleOperation)object;
                return Utilities.deepEquals(this.getMethod(), singleOperation.getMethod(), comparisonMode) && Utilities.deepEquals(this.getParameterValues(), singleOperation.getParameterValues(), comparisonMode);
            }
        }
        return true;
    }

    AbstractSingleOperation() {
    }

    private void setMethod(OperationMethod operationMethod) {
        if (this.method == null) {
            this.method = operationMethod;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractSingleOperation.class, "setMethod", "method");
        }
    }

    @XmlElement(name="parameterValue")
    private GeneralParameterValue[] getParameters() {
        List<GeneralParameterValue> list;
        if (this.parameters != null && (list = this.parameters.values()) != null) {
            return CC_OperationMethod.filterImplicit(list.toArray(new GeneralParameterValue[list.size()]));
        }
        return null;
    }

    private void setParameters(GeneralParameterValue[] generalParameterValueArray) {
        if (this.parameters == null) {
            if (!(this.method instanceof DefaultOperationMethod)) {
                throw new GeodeticException(Identifiers.missingValueForProperty(this.getName(), "method"));
            }
            IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor> identityHashMap = new IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor>(4);
            GeneralParameterDescriptor[] generalParameterDescriptorArray = CC_OperationParameterGroup.merge(this.method.getParameters().descriptors(), Parameters.getDescriptors(generalParameterValueArray), identityHashMap);
            for (int i = 0; i < generalParameterDescriptorArray.length; ++i) {
                if (generalParameterDescriptorArray[i] == generalParameterValueArray[i].getDescriptor()) continue;
                ((DefaultOperationMethod)this.method).updateDescriptors(generalParameterDescriptorArray);
                break;
            }
            this.parameters = new DefaultParameterValueGroup(this.method.getParameters());
            CC_OperationMethod.store(generalParameterValueArray, this.parameters.values(), identityHashMap);
            this.parameters = Parameters.unmodifiable(this.parameters);
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractSingleOperation.class, "setParameters", "parameterValue");
        }
    }

    @Override
    final void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        IdentifiedObject identifiedObject;
        super.afterUnmarshal(unmarshaller, object);
        if (this.parameters == null && this.method != null && (identifiedObject = this.method.getParameters()) != null && identifiedObject.descriptors().isEmpty()) {
            this.parameters = identifiedObject.createValue();
        }
        identifiedObject = super.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem = super.getTargetCRS();
        if (this.transform == null && identifiedObject != null && coordinateReferenceSystem != null && this.parameters != null) {
            try {
                this.transform = ReferencingUtilities.createBaseToDerived(DefaultFactories.forBuildin(MathTransformFactory.class), (CoordinateReferenceSystem)identifiedObject, this.parameters, coordinateReferenceSystem);
            }
            catch (FactoryException factoryException) {
                Context.warningOccured(Context.current(), AbstractSingleOperation.class, "afterUnmarshal", factoryException, true);
            }
        }
    }
}

